package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class DeleteServiceProviderRequest {




	private final String serviceProviderId;
	

	private DeleteServiceProviderRequest (
		final String serviceProviderId)
		
	{
		this.serviceProviderId = serviceProviderId;
		
	}
	
	/**
	 * 
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	

	public static class Builder {
		private String serviceProviderId;
		
		public Builder() {
			this.serviceProviderId = "";
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the DeleteServiceProviderRequest class
		  * @return The instantiated final DeleteServiceProviderRequest
		 **/
		public DeleteServiceProviderRequest build() {
			return new DeleteServiceProviderRequest(
				this.serviceProviderId);
		}
	}

	/**
	 * Returns a Builder for DeleteServiceProviderRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable DeleteServiceProviderRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the DeleteServiceProviderRequest instance
	 **/
	 public String toString() {
		 String result = "DeleteServiceProviderRequest\n";
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* DeleteServiceProviderRequest, which is much more usable.
	* @return An instance of DeleteServiceProviderRequest representing the input proto object
	**/
	public static DeleteServiceProviderRequest fromProto(ApiProto.DeleteServiceProviderRequest proto) {
		DeleteServiceProviderRequest out = null;
		if (proto != null) {
			DeleteServiceProviderRequest.Builder outBuilder = DeleteServiceProviderRequest.newBuilder()
			.setServiceProviderId(proto.getServiceProviderId());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of DeleteServiceProviderRequest instances representing the input proto objects
	**/
	public static List<DeleteServiceProviderRequest> fromProtos(List<ApiProto.DeleteServiceProviderRequest> protos) {
		List<DeleteServiceProviderRequest> out = new ArrayList<DeleteServiceProviderRequest>();
		for(ApiProto.DeleteServiceProviderRequest proto : protos) {
			out.add(DeleteServiceProviderRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.DeleteServiceProviderRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.DeleteServiceProviderRequest toProto() {
		 DeleteServiceProviderRequest obj = this;
		 ApiProto.DeleteServiceProviderRequest.Builder outBuilder = ApiProto.DeleteServiceProviderRequest.newBuilder();
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.DeleteServiceProviderRequest instances representing the input objects.
	  */
	public static List<ApiProto.DeleteServiceProviderRequest> toProtos(List<DeleteServiceProviderRequest> objects) {
		List<ApiProto.DeleteServiceProviderRequest> out = new ArrayList<ApiProto.DeleteServiceProviderRequest>();
		if(objects != null) {
			for (DeleteServiceProviderRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}