package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetEntryURLRequest {




	private final String serviceProviderId;
	private final ServiceContext context;
	

	private GetEntryURLRequest (
		final String serviceProviderId,
		final ServiceContext context)
		
	{
		this.serviceProviderId = serviceProviderId;
		this.context = context;
		
	}
	
	/**
	 * The service provider ID.
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	
	/**
	 * See ServiceContext for more information.
      * @return The final value of context on the object
	 **/
	public ServiceContext getContext() {
		return this.context;
	}
	

	public static class Builder {
		private String serviceProviderId;
		private ServiceContext context;
		
		public Builder() {
			this.serviceProviderId = "";
			this.context = null;
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for context
		  * @param context Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setContext(ServiceContext context) {
			this.context = context;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetEntryURLRequest class
		  * @return The instantiated final GetEntryURLRequest
		 **/
		public GetEntryURLRequest build() {
			return new GetEntryURLRequest(
				this.serviceProviderId,
				this.context);
		}
	}

	/**
	 * Returns a Builder for GetEntryURLRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetEntryURLRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetEntryURLRequest instance
	 **/
	 public String toString() {
		 String result = "GetEntryURLRequest\n";
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 result += "-> context: (ServiceContext)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.context).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetEntryURLRequest, which is much more usable.
	* @return An instance of GetEntryURLRequest representing the input proto object
	**/
	public static GetEntryURLRequest fromProto(ApiProto.GetEntryURLRequest proto) {
		GetEntryURLRequest out = null;
		if (proto != null) {
			GetEntryURLRequest.Builder outBuilder = GetEntryURLRequest.newBuilder()
			.setServiceProviderId(proto.getServiceProviderId())
			.setContext(ServiceContext.fromProto(proto.getContext()));
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetEntryURLRequest instances representing the input proto objects
	**/
	public static List<GetEntryURLRequest> fromProtos(List<ApiProto.GetEntryURLRequest> protos) {
		List<GetEntryURLRequest> out = new ArrayList<GetEntryURLRequest>();
		for(ApiProto.GetEntryURLRequest proto : protos) {
			out.add(GetEntryURLRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetEntryURLRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetEntryURLRequest toProto() {
		 GetEntryURLRequest obj = this;
		 ApiProto.GetEntryURLRequest.Builder outBuilder = ApiProto.GetEntryURLRequest.newBuilder();
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 if(obj.getContext() != null){outBuilder.setContext(obj.getContext().toProto());}
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetEntryURLRequest instances representing the input objects.
	  */
	public static List<ApiProto.GetEntryURLRequest> toProtos(List<GetEntryURLRequest> objects) {
		List<ApiProto.GetEntryURLRequest> out = new ArrayList<ApiProto.GetEntryURLRequest>();
		if(objects != null) {
			for (GetEntryURLRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}