package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetEntryURLResponse {




	private final String entryUrl;
	

	private GetEntryURLResponse (
		final String entryUrl)
		
	{
		this.entryUrl = entryUrl;
		
	}
	
	/**
	 * The entry URL
      * @return The final value of entryUrl on the object
	 **/
	public String getEntryUrl() {
		return this.entryUrl;
	}
	

	public static class Builder {
		private String entryUrl;
		
		public Builder() {
			this.entryUrl = "";
			
		}
		
		/**
		  * Adds a value to the builder for entryUrl
		  * @param entryUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setEntryUrl(String entryUrl) {
			this.entryUrl = entryUrl;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetEntryURLResponse class
		  * @return The instantiated final GetEntryURLResponse
		 **/
		public GetEntryURLResponse build() {
			return new GetEntryURLResponse(
				this.entryUrl);
		}
	}

	/**
	 * Returns a Builder for GetEntryURLResponse, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetEntryURLResponse object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetEntryURLResponse instance
	 **/
	 public String toString() {
		 String result = "GetEntryURLResponse\n";
		 result += "-> entryUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.entryUrl).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetEntryURLResponse, which is much more usable.
	* @return An instance of GetEntryURLResponse representing the input proto object
	**/
	public static GetEntryURLResponse fromProto(ApiProto.GetEntryURLResponse proto) {
		GetEntryURLResponse out = null;
		if (proto != null) {
			GetEntryURLResponse.Builder outBuilder = GetEntryURLResponse.newBuilder()
			.setEntryUrl(proto.getEntryUrl());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetEntryURLResponse instances representing the input proto objects
	**/
	public static List<GetEntryURLResponse> fromProtos(List<ApiProto.GetEntryURLResponse> protos) {
		List<GetEntryURLResponse> out = new ArrayList<GetEntryURLResponse>();
		for(ApiProto.GetEntryURLResponse proto : protos) {
			out.add(GetEntryURLResponse.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetEntryURLResponse which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetEntryURLResponse toProto() {
		 GetEntryURLResponse obj = this;
		 ApiProto.GetEntryURLResponse.Builder outBuilder = ApiProto.GetEntryURLResponse.newBuilder();
		 outBuilder.setEntryUrl(obj.getEntryUrl());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetEntryURLResponse instances representing the input objects.
	  */
	public static List<ApiProto.GetEntryURLResponse> toProtos(List<GetEntryURLResponse> objects) {
		List<ApiProto.GetEntryURLResponse> out = new ArrayList<ApiProto.GetEntryURLResponse>();
		if(objects != null) {
			for (GetEntryURLResponse obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}