package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetEntryURLWithCodeRequest {




	private final String serviceProviderId;
	private final String sessionId;
	private final String userId;
	private final String email;
	private final ServiceContext context;
	private final String nextUrl;
	private final String backUrl;
	private final String backUrlText;
	private final String federatedIdentityProvider;
	

	private GetEntryURLWithCodeRequest (
		final String serviceProviderId,
		final String sessionId,
		final String userId,
		final String email,
		final ServiceContext context,
		final String nextUrl,
		final String backUrl,
		final String backUrlText,
		final String federatedIdentityProvider)
		
	{
		this.serviceProviderId = serviceProviderId;
		this.sessionId = sessionId;
		this.userId = userId;
		this.email = email;
		this.context = context;
		this.nextUrl = nextUrl;
		this.backUrl = backUrl;
		this.backUrlText = backUrlText;
		this.federatedIdentityProvider = federatedIdentityProvider;
		
	}
	
	/**
	 * The service provider ID.
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	
	/**
	 * The session ID the identity provider wants to pass along to the service providers.
      * @return The final value of sessionId on the object
	 **/
	public String getSessionId() {
		return this.sessionId;
	}
	
	/**
	 * The user ID.
      * @return The final value of userId on the object
	 **/
	public String getUserId() {
		return this.userId;
	}
	
	/**
	 * The user's email.
      * @return The final value of email on the object
	 **/
	public String getEmail() {
		return this.email;
	}
	
	/**
	 * The service context needed to help determine which identity provider to use.
      * @return The final value of context on the object
	 **/
	public ServiceContext getContext() {
		return this.context;
	}
	
	/**
	 * The next URL to send the user to, once the code exchange is complete on the entry URL.
      * @return The final value of nextUrl on the object
	 **/
	public String getNextUrl() {
		return this.nextUrl;
	}
	
	/**
	 * The back url is the url that clicking the "Back" in the navigation bar
      * @return The final value of backUrl on the object
	 **/
	public String getBackUrl() {
		return this.backUrl;
	}
	
	/**
	 * Back url text is the text that will be displayed for the back button in the navigation
      * @return The final value of backUrlText on the object
	 **/
	public String getBackUrlText() {
		return this.backUrlText;
	}
	
	/**
	 * Denotes if an identity is delegated to another identity provider, e.g. google
      * @return The final value of federatedIdentityProvider on the object
	 **/
	public String getFederatedIdentityProvider() {
		return this.federatedIdentityProvider;
	}
	

	public static class Builder {
		private String serviceProviderId;
		private String sessionId;
		private String userId;
		private String email;
		private ServiceContext context;
		private String nextUrl;
		private String backUrl;
		private String backUrlText;
		private String federatedIdentityProvider;
		
		public Builder() {
			this.serviceProviderId = "";
			this.sessionId = "";
			this.userId = "";
			this.email = "";
			this.context = null;
			this.nextUrl = "";
			this.backUrl = "";
			this.backUrlText = "";
			this.federatedIdentityProvider = "";
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for sessionId
		  * @param sessionId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setSessionId(String sessionId) {
			this.sessionId = sessionId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for userId
		  * @param userId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setUserId(String userId) {
			this.userId = userId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for email
		  * @param email Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setEmail(String email) {
			this.email = email;
			return this;
		}
		
		/**
		  * Adds a value to the builder for context
		  * @param context Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setContext(ServiceContext context) {
			this.context = context;
			return this;
		}
		
		/**
		  * Adds a value to the builder for nextUrl
		  * @param nextUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setNextUrl(String nextUrl) {
			this.nextUrl = nextUrl;
			return this;
		}
		
		/**
		  * Adds a value to the builder for backUrl
		  * @param backUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setBackUrl(String backUrl) {
			this.backUrl = backUrl;
			return this;
		}
		
		/**
		  * Adds a value to the builder for backUrlText
		  * @param backUrlText Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setBackUrlText(String backUrlText) {
			this.backUrlText = backUrlText;
			return this;
		}
		
		/**
		  * Adds a value to the builder for federatedIdentityProvider
		  * @param federatedIdentityProvider Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setFederatedIdentityProvider(String federatedIdentityProvider) {
			this.federatedIdentityProvider = federatedIdentityProvider;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetEntryURLWithCodeRequest class
		  * @return The instantiated final GetEntryURLWithCodeRequest
		 **/
		public GetEntryURLWithCodeRequest build() {
			return new GetEntryURLWithCodeRequest(
				this.serviceProviderId,
				this.sessionId,
				this.userId,
				this.email,
				this.context,
				this.nextUrl,
				this.backUrl,
				this.backUrlText,
				this.federatedIdentityProvider);
		}
	}

	/**
	 * Returns a Builder for GetEntryURLWithCodeRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetEntryURLWithCodeRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetEntryURLWithCodeRequest instance
	 **/
	 public String toString() {
		 String result = "GetEntryURLWithCodeRequest\n";
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 result += "-> sessionId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.sessionId).split("\n"))) + "\n"; 
		 result += "-> userId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.userId).split("\n"))) + "\n"; 
		 result += "-> email: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.email).split("\n"))) + "\n"; 
		 result += "-> context: (ServiceContext)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.context).split("\n"))) + "\n"; 
		 result += "-> nextUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.nextUrl).split("\n"))) + "\n"; 
		 result += "-> backUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.backUrl).split("\n"))) + "\n"; 
		 result += "-> backUrlText: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.backUrlText).split("\n"))) + "\n"; 
		 result += "-> federatedIdentityProvider: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.federatedIdentityProvider).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetEntryURLWithCodeRequest, which is much more usable.
	* @return An instance of GetEntryURLWithCodeRequest representing the input proto object
	**/
	public static GetEntryURLWithCodeRequest fromProto(ApiProto.GetEntryURLWithCodeRequest proto) {
		GetEntryURLWithCodeRequest out = null;
		if (proto != null) {
			GetEntryURLWithCodeRequest.Builder outBuilder = GetEntryURLWithCodeRequest.newBuilder()
			.setServiceProviderId(proto.getServiceProviderId())
			.setSessionId(proto.getSessionId())
			.setUserId(proto.getUserId())
			.setEmail(proto.getEmail())
			.setContext(ServiceContext.fromProto(proto.getContext()))
			.setNextUrl(proto.getNextUrl())
			.setBackUrl(proto.getBackUrl())
			.setBackUrlText(proto.getBackUrlText())
			.setFederatedIdentityProvider(proto.getFederatedIdentityProvider());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetEntryURLWithCodeRequest instances representing the input proto objects
	**/
	public static List<GetEntryURLWithCodeRequest> fromProtos(List<ApiProto.GetEntryURLWithCodeRequest> protos) {
		List<GetEntryURLWithCodeRequest> out = new ArrayList<GetEntryURLWithCodeRequest>();
		for(ApiProto.GetEntryURLWithCodeRequest proto : protos) {
			out.add(GetEntryURLWithCodeRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetEntryURLWithCodeRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetEntryURLWithCodeRequest toProto() {
		 GetEntryURLWithCodeRequest obj = this;
		 ApiProto.GetEntryURLWithCodeRequest.Builder outBuilder = ApiProto.GetEntryURLWithCodeRequest.newBuilder();
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 outBuilder.setSessionId(obj.getSessionId());
		 outBuilder.setUserId(obj.getUserId());
		 outBuilder.setEmail(obj.getEmail());
		 if(obj.getContext() != null){outBuilder.setContext(obj.getContext().toProto());}
		 outBuilder.setNextUrl(obj.getNextUrl());
		 outBuilder.setBackUrl(obj.getBackUrl());
		 outBuilder.setBackUrlText(obj.getBackUrlText());
		 outBuilder.setFederatedIdentityProvider(obj.getFederatedIdentityProvider());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetEntryURLWithCodeRequest instances representing the input objects.
	  */
	public static List<ApiProto.GetEntryURLWithCodeRequest> toProtos(List<GetEntryURLWithCodeRequest> objects) {
		List<ApiProto.GetEntryURLWithCodeRequest> out = new ArrayList<ApiProto.GetEntryURLWithCodeRequest>();
		if(objects != null) {
			for (GetEntryURLWithCodeRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}