package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetEntryURLWithCodeResponse {




	private final String entryUrl;
	

	private GetEntryURLWithCodeResponse (
		final String entryUrl)
		
	{
		this.entryUrl = entryUrl;
		
	}
	
	/**
	 * The entry URL, containing the code in the query params
      * @return The final value of entryUrl on the object
	 **/
	public String getEntryUrl() {
		return this.entryUrl;
	}
	

	public static class Builder {
		private String entryUrl;
		
		public Builder() {
			this.entryUrl = "";
			
		}
		
		/**
		  * Adds a value to the builder for entryUrl
		  * @param entryUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setEntryUrl(String entryUrl) {
			this.entryUrl = entryUrl;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetEntryURLWithCodeResponse class
		  * @return The instantiated final GetEntryURLWithCodeResponse
		 **/
		public GetEntryURLWithCodeResponse build() {
			return new GetEntryURLWithCodeResponse(
				this.entryUrl);
		}
	}

	/**
	 * Returns a Builder for GetEntryURLWithCodeResponse, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetEntryURLWithCodeResponse object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetEntryURLWithCodeResponse instance
	 **/
	 public String toString() {
		 String result = "GetEntryURLWithCodeResponse\n";
		 result += "-> entryUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.entryUrl).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetEntryURLWithCodeResponse, which is much more usable.
	* @return An instance of GetEntryURLWithCodeResponse representing the input proto object
	**/
	public static GetEntryURLWithCodeResponse fromProto(ApiProto.GetEntryURLWithCodeResponse proto) {
		GetEntryURLWithCodeResponse out = null;
		if (proto != null) {
			GetEntryURLWithCodeResponse.Builder outBuilder = GetEntryURLWithCodeResponse.newBuilder()
			.setEntryUrl(proto.getEntryUrl());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetEntryURLWithCodeResponse instances representing the input proto objects
	**/
	public static List<GetEntryURLWithCodeResponse> fromProtos(List<ApiProto.GetEntryURLWithCodeResponse> protos) {
		List<GetEntryURLWithCodeResponse> out = new ArrayList<GetEntryURLWithCodeResponse>();
		for(ApiProto.GetEntryURLWithCodeResponse proto : protos) {
			out.add(GetEntryURLWithCodeResponse.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetEntryURLWithCodeResponse which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetEntryURLWithCodeResponse toProto() {
		 GetEntryURLWithCodeResponse obj = this;
		 ApiProto.GetEntryURLWithCodeResponse.Builder outBuilder = ApiProto.GetEntryURLWithCodeResponse.newBuilder();
		 outBuilder.setEntryUrl(obj.getEntryUrl());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetEntryURLWithCodeResponse instances representing the input objects.
	  */
	public static List<ApiProto.GetEntryURLWithCodeResponse> toProtos(List<GetEntryURLWithCodeResponse> objects) {
		List<ApiProto.GetEntryURLWithCodeResponse> out = new ArrayList<ApiProto.GetEntryURLWithCodeResponse>();
		if(objects != null) {
			for (GetEntryURLWithCodeResponse obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}