package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetLogoutURLRequest {




	private final String sessionId;
	private final ServiceContext context;
	private final String serviceProviderId;
	

	private GetLogoutURLRequest (
		final String sessionId,
		final ServiceContext context,
		final String serviceProviderId)
		
	{
		this.sessionId = sessionId;
		this.context = context;
		this.serviceProviderId = serviceProviderId;
		
	}
	
	/**
	 * The user's session id
      * @return The final value of sessionId on the object
	 **/
	public String getSessionId() {
		return this.sessionId;
	}
	
	/**
	 * The service context.
      * @return The final value of context on the object
	 **/
	public ServiceContext getContext() {
		return this.context;
	}
	
	/**
	 * The service provider id is used for when a logout happens and the user tries to re-login.
	 *  SSO needs to know the user's next destination, so this endpoint will go back to the application
	 *  the user had just logged out of when building the logout url.
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	

	public static class Builder {
		private String sessionId;
		private ServiceContext context;
		private String serviceProviderId;
		
		public Builder() {
			this.sessionId = "";
			this.context = null;
			this.serviceProviderId = "";
			
		}
		
		/**
		  * Adds a value to the builder for sessionId
		  * @param sessionId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setSessionId(String sessionId) {
			this.sessionId = sessionId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for context
		  * @param context Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setContext(ServiceContext context) {
			this.context = context;
			return this;
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetLogoutURLRequest class
		  * @return The instantiated final GetLogoutURLRequest
		 **/
		public GetLogoutURLRequest build() {
			return new GetLogoutURLRequest(
				this.sessionId,
				this.context,
				this.serviceProviderId);
		}
	}

	/**
	 * Returns a Builder for GetLogoutURLRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetLogoutURLRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetLogoutURLRequest instance
	 **/
	 public String toString() {
		 String result = "GetLogoutURLRequest\n";
		 result += "-> sessionId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.sessionId).split("\n"))) + "\n"; 
		 result += "-> context: (ServiceContext)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.context).split("\n"))) + "\n"; 
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetLogoutURLRequest, which is much more usable.
	* @return An instance of GetLogoutURLRequest representing the input proto object
	**/
	public static GetLogoutURLRequest fromProto(ApiProto.GetLogoutURLRequest proto) {
		GetLogoutURLRequest out = null;
		if (proto != null) {
			GetLogoutURLRequest.Builder outBuilder = GetLogoutURLRequest.newBuilder()
			.setSessionId(proto.getSessionId())
			.setContext(ServiceContext.fromProto(proto.getContext()))
			.setServiceProviderId(proto.getServiceProviderId());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetLogoutURLRequest instances representing the input proto objects
	**/
	public static List<GetLogoutURLRequest> fromProtos(List<ApiProto.GetLogoutURLRequest> protos) {
		List<GetLogoutURLRequest> out = new ArrayList<GetLogoutURLRequest>();
		for(ApiProto.GetLogoutURLRequest proto : protos) {
			out.add(GetLogoutURLRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetLogoutURLRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetLogoutURLRequest toProto() {
		 GetLogoutURLRequest obj = this;
		 ApiProto.GetLogoutURLRequest.Builder outBuilder = ApiProto.GetLogoutURLRequest.newBuilder();
		 outBuilder.setSessionId(obj.getSessionId());
		 if(obj.getContext() != null){outBuilder.setContext(obj.getContext().toProto());}
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetLogoutURLRequest instances representing the input objects.
	  */
	public static List<ApiProto.GetLogoutURLRequest> toProtos(List<GetLogoutURLRequest> objects) {
		List<ApiProto.GetLogoutURLRequest> out = new ArrayList<ApiProto.GetLogoutURLRequest>();
		if(objects != null) {
			for (GetLogoutURLRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}