package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetLogoutURLResponse {




	private final String logoutUrl;
	

	private GetLogoutURLResponse (
		final String logoutUrl)
		
	{
		this.logoutUrl = logoutUrl;
		
	}
	
	/**
	 * The url to redirect to for logging out.
      * @return The final value of logoutUrl on the object
	 **/
	public String getLogoutUrl() {
		return this.logoutUrl;
	}
	

	public static class Builder {
		private String logoutUrl;
		
		public Builder() {
			this.logoutUrl = "";
			
		}
		
		/**
		  * Adds a value to the builder for logoutUrl
		  * @param logoutUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setLogoutUrl(String logoutUrl) {
			this.logoutUrl = logoutUrl;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetLogoutURLResponse class
		  * @return The instantiated final GetLogoutURLResponse
		 **/
		public GetLogoutURLResponse build() {
			return new GetLogoutURLResponse(
				this.logoutUrl);
		}
	}

	/**
	 * Returns a Builder for GetLogoutURLResponse, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetLogoutURLResponse object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetLogoutURLResponse instance
	 **/
	 public String toString() {
		 String result = "GetLogoutURLResponse\n";
		 result += "-> logoutUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.logoutUrl).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetLogoutURLResponse, which is much more usable.
	* @return An instance of GetLogoutURLResponse representing the input proto object
	**/
	public static GetLogoutURLResponse fromProto(ApiProto.GetLogoutURLResponse proto) {
		GetLogoutURLResponse out = null;
		if (proto != null) {
			GetLogoutURLResponse.Builder outBuilder = GetLogoutURLResponse.newBuilder()
			.setLogoutUrl(proto.getLogoutUrl());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetLogoutURLResponse instances representing the input proto objects
	**/
	public static List<GetLogoutURLResponse> fromProtos(List<ApiProto.GetLogoutURLResponse> protos) {
		List<GetLogoutURLResponse> out = new ArrayList<GetLogoutURLResponse>();
		for(ApiProto.GetLogoutURLResponse proto : protos) {
			out.add(GetLogoutURLResponse.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetLogoutURLResponse which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetLogoutURLResponse toProto() {
		 GetLogoutURLResponse obj = this;
		 ApiProto.GetLogoutURLResponse.Builder outBuilder = ApiProto.GetLogoutURLResponse.newBuilder();
		 outBuilder.setLogoutUrl(obj.getLogoutUrl());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetLogoutURLResponse instances representing the input objects.
	  */
	public static List<ApiProto.GetLogoutURLResponse> toProtos(List<GetLogoutURLResponse> objects) {
		List<ApiProto.GetLogoutURLResponse> out = new ArrayList<ApiProto.GetLogoutURLResponse>();
		if(objects != null) {
			for (GetLogoutURLResponse obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}