package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetMultiEntryURLRequest {




	private final List<String> serviceProviderIds;
	private final ServiceContext context;
	

	private GetMultiEntryURLRequest (
		final List<String> serviceProviderIds,
		final ServiceContext context)
		
	{
		this.serviceProviderIds = serviceProviderIds;
		this.context = context;
		
	}
	
	/**
	 * A list of service provider IDs to get entry urls for
      * @return The final value of serviceProviderIds on the object
	 **/
	public List<String> getServiceProviderIds() {
		return this.serviceProviderIds;
	}
	
	/**
	 * See ServiceContext for more information to build the entry urls.
      * @return The final value of context on the object
	 **/
	public ServiceContext getContext() {
		return this.context;
	}
	

	public static class Builder {
		private List<String> serviceProviderIds;
		private ServiceContext context;
		
		public Builder() {
			this.serviceProviderIds = new ArrayList<String>();
			this.context = null;
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderIds
		  * @param serviceProviderIds Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderIds(List<String> serviceProviderIds) {
			this.serviceProviderIds = serviceProviderIds;
			return this;
		}
		
		/**
		  * Adds a value to the builder for context
		  * @param context Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setContext(ServiceContext context) {
			this.context = context;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetMultiEntryURLRequest class
		  * @return The instantiated final GetMultiEntryURLRequest
		 **/
		public GetMultiEntryURLRequest build() {
			return new GetMultiEntryURLRequest(
				this.serviceProviderIds,
				this.context);
		}
	}

	/**
	 * Returns a Builder for GetMultiEntryURLRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetMultiEntryURLRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetMultiEntryURLRequest instance
	 **/
	 public String toString() {
		 String result = "GetMultiEntryURLRequest\n";
		 result += "-> serviceProviderIds: (List<String>)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderIds).split("\n"))) + "\n"; 
		 result += "-> context: (ServiceContext)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.context).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetMultiEntryURLRequest, which is much more usable.
	* @return An instance of GetMultiEntryURLRequest representing the input proto object
	**/
	public static GetMultiEntryURLRequest fromProto(ApiProto.GetMultiEntryURLRequest proto) {
		GetMultiEntryURLRequest out = null;
		if (proto != null) {
			GetMultiEntryURLRequest.Builder outBuilder = GetMultiEntryURLRequest.newBuilder()
			.setServiceProviderIds(proto.getServiceProviderIdsList())
			.setContext(ServiceContext.fromProto(proto.getContext()));
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetMultiEntryURLRequest instances representing the input proto objects
	**/
	public static List<GetMultiEntryURLRequest> fromProtos(List<ApiProto.GetMultiEntryURLRequest> protos) {
		List<GetMultiEntryURLRequest> out = new ArrayList<GetMultiEntryURLRequest>();
		for(ApiProto.GetMultiEntryURLRequest proto : protos) {
			out.add(GetMultiEntryURLRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetMultiEntryURLRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetMultiEntryURLRequest toProto() {
		 GetMultiEntryURLRequest obj = this;
		 ApiProto.GetMultiEntryURLRequest.Builder outBuilder = ApiProto.GetMultiEntryURLRequest.newBuilder();
		 outBuilder.addAllServiceProviderIds(obj.getServiceProviderIds());
		 if(obj.getContext() != null){outBuilder.setContext(obj.getContext().toProto());}
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetMultiEntryURLRequest instances representing the input objects.
	  */
	public static List<ApiProto.GetMultiEntryURLRequest> toProtos(List<GetMultiEntryURLRequest> objects) {
		List<ApiProto.GetMultiEntryURLRequest> out = new ArrayList<ApiProto.GetMultiEntryURLRequest>();
		if(objects != null) {
			for (GetMultiEntryURLRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}