package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetMultiEntryURLResponse {




	private final List<String> entryUrls;
	

	private GetMultiEntryURLResponse (
		final List<String> entryUrls)
		
	{
		this.entryUrls = entryUrls;
		
	}
	
	/**
	 * An ordered list of entry urls. Order corresponds to the service provider id request order.
      * @return The final value of entryUrls on the object
	 **/
	public List<String> getEntryUrls() {
		return this.entryUrls;
	}
	

	public static class Builder {
		private List<String> entryUrls;
		
		public Builder() {
			this.entryUrls = new ArrayList<String>();
			
		}
		
		/**
		  * Adds a value to the builder for entryUrls
		  * @param entryUrls Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setEntryUrls(List<String> entryUrls) {
			this.entryUrls = entryUrls;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetMultiEntryURLResponse class
		  * @return The instantiated final GetMultiEntryURLResponse
		 **/
		public GetMultiEntryURLResponse build() {
			return new GetMultiEntryURLResponse(
				this.entryUrls);
		}
	}

	/**
	 * Returns a Builder for GetMultiEntryURLResponse, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetMultiEntryURLResponse object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetMultiEntryURLResponse instance
	 **/
	 public String toString() {
		 String result = "GetMultiEntryURLResponse\n";
		 result += "-> entryUrls: (List<String>)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.entryUrls).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetMultiEntryURLResponse, which is much more usable.
	* @return An instance of GetMultiEntryURLResponse representing the input proto object
	**/
	public static GetMultiEntryURLResponse fromProto(ApiProto.GetMultiEntryURLResponse proto) {
		GetMultiEntryURLResponse out = null;
		if (proto != null) {
			GetMultiEntryURLResponse.Builder outBuilder = GetMultiEntryURLResponse.newBuilder()
			.setEntryUrls(proto.getEntryUrlsList());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetMultiEntryURLResponse instances representing the input proto objects
	**/
	public static List<GetMultiEntryURLResponse> fromProtos(List<ApiProto.GetMultiEntryURLResponse> protos) {
		List<GetMultiEntryURLResponse> out = new ArrayList<GetMultiEntryURLResponse>();
		for(ApiProto.GetMultiEntryURLResponse proto : protos) {
			out.add(GetMultiEntryURLResponse.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetMultiEntryURLResponse which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetMultiEntryURLResponse toProto() {
		 GetMultiEntryURLResponse obj = this;
		 ApiProto.GetMultiEntryURLResponse.Builder outBuilder = ApiProto.GetMultiEntryURLResponse.newBuilder();
		 outBuilder.addAllEntryUrls(obj.getEntryUrls());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetMultiEntryURLResponse instances representing the input objects.
	  */
	public static List<ApiProto.GetMultiEntryURLResponse> toProtos(List<GetMultiEntryURLResponse> objects) {
		List<ApiProto.GetMultiEntryURLResponse> out = new ArrayList<ApiProto.GetMultiEntryURLResponse>();
		if(objects != null) {
			for (GetMultiEntryURLResponse obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}