package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetServiceProviderRequest {




	private final String serviceProviderId;
	

	private GetServiceProviderRequest (
		final String serviceProviderId)
		
	{
		this.serviceProviderId = serviceProviderId;
		
	}
	
	/**
	 * 
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	

	public static class Builder {
		private String serviceProviderId;
		
		public Builder() {
			this.serviceProviderId = "";
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetServiceProviderRequest class
		  * @return The instantiated final GetServiceProviderRequest
		 **/
		public GetServiceProviderRequest build() {
			return new GetServiceProviderRequest(
				this.serviceProviderId);
		}
	}

	/**
	 * Returns a Builder for GetServiceProviderRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetServiceProviderRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetServiceProviderRequest instance
	 **/
	 public String toString() {
		 String result = "GetServiceProviderRequest\n";
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetServiceProviderRequest, which is much more usable.
	* @return An instance of GetServiceProviderRequest representing the input proto object
	**/
	public static GetServiceProviderRequest fromProto(ApiProto.GetServiceProviderRequest proto) {
		GetServiceProviderRequest out = null;
		if (proto != null) {
			GetServiceProviderRequest.Builder outBuilder = GetServiceProviderRequest.newBuilder()
			.setServiceProviderId(proto.getServiceProviderId());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetServiceProviderRequest instances representing the input proto objects
	**/
	public static List<GetServiceProviderRequest> fromProtos(List<ApiProto.GetServiceProviderRequest> protos) {
		List<GetServiceProviderRequest> out = new ArrayList<GetServiceProviderRequest>();
		for(ApiProto.GetServiceProviderRequest proto : protos) {
			out.add(GetServiceProviderRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetServiceProviderRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetServiceProviderRequest toProto() {
		 GetServiceProviderRequest obj = this;
		 ApiProto.GetServiceProviderRequest.Builder outBuilder = ApiProto.GetServiceProviderRequest.newBuilder();
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetServiceProviderRequest instances representing the input objects.
	  */
	public static List<ApiProto.GetServiceProviderRequest> toProtos(List<GetServiceProviderRequest> objects) {
		List<ApiProto.GetServiceProviderRequest> out = new ArrayList<ApiProto.GetServiceProviderRequest>();
		if(objects != null) {
			for (GetServiceProviderRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}