package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetSessionTransferURLRequest {




	private final String serviceProviderId;
	private final ServiceContext context;
	

	private GetSessionTransferURLRequest (
		final String serviceProviderId,
		final ServiceContext context)
		
	{
		this.serviceProviderId = serviceProviderId;
		this.context = context;
		
	}
	
	/**
	 * An ID unique to a service/application (such as a marketplace application ID)
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	
	/**
	 * The service context.
      * @return The final value of context on the object
	 **/
	public ServiceContext getContext() {
		return this.context;
	}
	

	public static class Builder {
		private String serviceProviderId;
		private ServiceContext context;
		
		public Builder() {
			this.serviceProviderId = "";
			this.context = null;
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for context
		  * @param context Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setContext(ServiceContext context) {
			this.context = context;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetSessionTransferURLRequest class
		  * @return The instantiated final GetSessionTransferURLRequest
		 **/
		public GetSessionTransferURLRequest build() {
			return new GetSessionTransferURLRequest(
				this.serviceProviderId,
				this.context);
		}
	}

	/**
	 * Returns a Builder for GetSessionTransferURLRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetSessionTransferURLRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetSessionTransferURLRequest instance
	 **/
	 public String toString() {
		 String result = "GetSessionTransferURLRequest\n";
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 result += "-> context: (ServiceContext)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.context).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetSessionTransferURLRequest, which is much more usable.
	* @return An instance of GetSessionTransferURLRequest representing the input proto object
	**/
	public static GetSessionTransferURLRequest fromProto(ApiProto.GetSessionTransferURLRequest proto) {
		GetSessionTransferURLRequest out = null;
		if (proto != null) {
			GetSessionTransferURLRequest.Builder outBuilder = GetSessionTransferURLRequest.newBuilder()
			.setServiceProviderId(proto.getServiceProviderId())
			.setContext(ServiceContext.fromProto(proto.getContext()));
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetSessionTransferURLRequest instances representing the input proto objects
	**/
	public static List<GetSessionTransferURLRequest> fromProtos(List<ApiProto.GetSessionTransferURLRequest> protos) {
		List<GetSessionTransferURLRequest> out = new ArrayList<GetSessionTransferURLRequest>();
		for(ApiProto.GetSessionTransferURLRequest proto : protos) {
			out.add(GetSessionTransferURLRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetSessionTransferURLRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetSessionTransferURLRequest toProto() {
		 GetSessionTransferURLRequest obj = this;
		 ApiProto.GetSessionTransferURLRequest.Builder outBuilder = ApiProto.GetSessionTransferURLRequest.newBuilder();
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 if(obj.getContext() != null){outBuilder.setContext(obj.getContext().toProto());}
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetSessionTransferURLRequest instances representing the input objects.
	  */
	public static List<ApiProto.GetSessionTransferURLRequest> toProtos(List<GetSessionTransferURLRequest> objects) {
		List<ApiProto.GetSessionTransferURLRequest> out = new ArrayList<ApiProto.GetSessionTransferURLRequest>();
		if(objects != null) {
			for (GetSessionTransferURLRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}