package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class GetSessionTransferURLResponse {




	private final String sessionTransferUrl;
	

	private GetSessionTransferURLResponse (
		final String sessionTransferUrl)
		
	{
		this.sessionTransferUrl = sessionTransferUrl;
		
	}
	
	/**
	 * The session transfer URL to send the user to (which may result in a redirect to a login screen).
      * @return The final value of sessionTransferUrl on the object
	 **/
	public String getSessionTransferUrl() {
		return this.sessionTransferUrl;
	}
	

	public static class Builder {
		private String sessionTransferUrl;
		
		public Builder() {
			this.sessionTransferUrl = "";
			
		}
		
		/**
		  * Adds a value to the builder for sessionTransferUrl
		  * @param sessionTransferUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setSessionTransferUrl(String sessionTransferUrl) {
			this.sessionTransferUrl = sessionTransferUrl;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the GetSessionTransferURLResponse class
		  * @return The instantiated final GetSessionTransferURLResponse
		 **/
		public GetSessionTransferURLResponse build() {
			return new GetSessionTransferURLResponse(
				this.sessionTransferUrl);
		}
	}

	/**
	 * Returns a Builder for GetSessionTransferURLResponse, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable GetSessionTransferURLResponse object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the GetSessionTransferURLResponse instance
	 **/
	 public String toString() {
		 String result = "GetSessionTransferURLResponse\n";
		 result += "-> sessionTransferUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.sessionTransferUrl).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* GetSessionTransferURLResponse, which is much more usable.
	* @return An instance of GetSessionTransferURLResponse representing the input proto object
	**/
	public static GetSessionTransferURLResponse fromProto(ApiProto.GetSessionTransferURLResponse proto) {
		GetSessionTransferURLResponse out = null;
		if (proto != null) {
			GetSessionTransferURLResponse.Builder outBuilder = GetSessionTransferURLResponse.newBuilder()
			.setSessionTransferUrl(proto.getSessionTransferUrl());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of GetSessionTransferURLResponse instances representing the input proto objects
	**/
	public static List<GetSessionTransferURLResponse> fromProtos(List<ApiProto.GetSessionTransferURLResponse> protos) {
		List<GetSessionTransferURLResponse> out = new ArrayList<GetSessionTransferURLResponse>();
		for(ApiProto.GetSessionTransferURLResponse proto : protos) {
			out.add(GetSessionTransferURLResponse.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.GetSessionTransferURLResponse which is a proto object ready for wire transmission
	 **/
	 public ApiProto.GetSessionTransferURLResponse toProto() {
		 GetSessionTransferURLResponse obj = this;
		 ApiProto.GetSessionTransferURLResponse.Builder outBuilder = ApiProto.GetSessionTransferURLResponse.newBuilder();
		 outBuilder.setSessionTransferUrl(obj.getSessionTransferUrl());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.GetSessionTransferURLResponse instances representing the input objects.
	  */
	public static List<ApiProto.GetSessionTransferURLResponse> toProtos(List<GetSessionTransferURLResponse> objects) {
		List<ApiProto.GetSessionTransferURLResponse> out = new ArrayList<ApiProto.GetSessionTransferURLResponse>();
		if(objects != null) {
			for (GetSessionTransferURLResponse obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}