package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class LogoutRequest {




	private final String sessionId;
	

	private LogoutRequest (
		final String sessionId)
		
	{
		this.sessionId = sessionId;
		
	}
	
	/**
	 * The session ID to logout
      * @return The final value of sessionId on the object
	 **/
	public String getSessionId() {
		return this.sessionId;
	}
	

	public static class Builder {
		private String sessionId;
		
		public Builder() {
			this.sessionId = "";
			
		}
		
		/**
		  * Adds a value to the builder for sessionId
		  * @param sessionId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setSessionId(String sessionId) {
			this.sessionId = sessionId;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the LogoutRequest class
		  * @return The instantiated final LogoutRequest
		 **/
		public LogoutRequest build() {
			return new LogoutRequest(
				this.sessionId);
		}
	}

	/**
	 * Returns a Builder for LogoutRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable LogoutRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the LogoutRequest instance
	 **/
	 public String toString() {
		 String result = "LogoutRequest\n";
		 result += "-> sessionId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.sessionId).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* LogoutRequest, which is much more usable.
	* @return An instance of LogoutRequest representing the input proto object
	**/
	public static LogoutRequest fromProto(ApiProto.LogoutRequest proto) {
		LogoutRequest out = null;
		if (proto != null) {
			LogoutRequest.Builder outBuilder = LogoutRequest.newBuilder()
			.setSessionId(proto.getSessionId());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of LogoutRequest instances representing the input proto objects
	**/
	public static List<LogoutRequest> fromProtos(List<ApiProto.LogoutRequest> protos) {
		List<LogoutRequest> out = new ArrayList<LogoutRequest>();
		for(ApiProto.LogoutRequest proto : protos) {
			out.add(LogoutRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.LogoutRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.LogoutRequest toProto() {
		 LogoutRequest obj = this;
		 ApiProto.LogoutRequest.Builder outBuilder = ApiProto.LogoutRequest.newBuilder();
		 outBuilder.setSessionId(obj.getSessionId());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.LogoutRequest instances representing the input objects.
	  */
	public static List<ApiProto.LogoutRequest> toProtos(List<LogoutRequest> objects) {
		List<ApiProto.LogoutRequest> out = new ArrayList<ApiProto.LogoutRequest>();
		if(objects != null) {
			for (LogoutRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}