package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ServiceProviderProto;

/**
 * The service context is used to determine which identity provider to use. This context is used in conjunction with
 *  the identity context, provided by the identity provider. The two contexts require domain logic to be glued together;
 *  for example, when the service provider provides an account, we can determine the partner from that account, then
 *  match that up to an identity provider Partner context.
 **/
public final class ServiceContext {



	/**
	 * 
	 **/
	public static final class Account {
	
	
	
	
		private final String accountId;
		
	
		private Account (
			final String accountId)
			
		{
			this.accountId = accountId;
			
		}
		
		/**
		 * 
	      * @return The final value of accountId on the object
		 **/
		public String getAccountId() {
			return this.accountId;
		}
		
	
		public static class Builder {
			private String accountId;
			
			public Builder() {
				this.accountId = "";
				
			}
			
			/**
			  * Adds a value to the builder for accountId
			  * @param accountId Value to assign to the mutable Builder
			  * @return The Builder instance so that call chaining works
			 **/
			public Builder setAccountId(String accountId) {
				this.accountId = accountId;
				return this;
			}
			
			/**
			  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
			  * of the Account class
			  * @return The instantiated final Account
			 **/
			public Account build() {
				return new Account(
					this.accountId);
			}
		}
	
		/**
		 * Returns a Builder for Account, which is a mutable representation of the object.  Once the
		 * client has built up an object they can then create an immutable Account object using the
		 * build function.
		 * @return A fresh Builder instance with no values set
		 **/
		public static Builder newBuilder() {
			return new Builder();
		}
	
		/**
		 * Provides a human-readable representation of this object.  Useful for debugging.
		 * @return A string representation of the Account instance
		 **/
		 public String toString() {
			 String result = "Account\n";
			 result += "-> accountId: (String)"
			     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.accountId).split("\n"))) + "\n"; 
			 
			 return result;
		 }
		/**
		* Allows for simple conversion between the low-level generated protobuf object to
		* Account, which is much more usable.
		* @return An instance of Account representing the input proto object
		**/
		public static Account fromProto(ServiceProviderProto.ServiceContext.Account proto) {
			Account out = null;
			if (proto != null) {
				Account.Builder outBuilder = Account.newBuilder()
				.setAccountId(proto.getAccountId());
				out = outBuilder.build();
			}
			return out;
		}
	
		/**
		* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
		* and returns a list of the converted results.
		* @return A list of Account instances representing the input proto objects
		**/
		public static List<Account> fromProtos(List<ServiceProviderProto.ServiceContext.Account> protos) {
			List<Account> out = new ArrayList<Account>();
			for(ServiceProviderProto.ServiceContext.Account proto : protos) {
				out.add(Account.fromProto(proto));
			}
			return out;
		}
	
		/**
		 * Allows for simple conversion of an object to the low-level generated protobuf object.
		 * @return An instance of ServiceProviderProto.ServiceContext.Account which is a proto object ready for wire transmission
		 **/
		 public ServiceProviderProto.ServiceContext.Account toProto() {
			 Account obj = this;
			 ServiceProviderProto.ServiceContext.Account.Builder outBuilder = ServiceProviderProto.ServiceContext.Account.newBuilder();
			 outBuilder.setAccountId(obj.getAccountId());
			 return outBuilder.build();
		 }
	
		 /**
		  * Convenience method for handling lists of objects.  It calls .toProto on each one and
		  * returns a list of the converted results.
		  * @return A list of ServiceProviderProto.ServiceContext.Account instances representing the input objects.
		  */
		public static List<ServiceProviderProto.ServiceContext.Account> toProtos(List<Account> objects) {
			List<ServiceProviderProto.ServiceContext.Account> out = new ArrayList<ServiceProviderProto.ServiceContext.Account>();
			if(objects != null) {
				for (Account obj : objects) {
					out.add(obj!=null?obj.toProto():null);
				}
			}
			return out;
		}
	}
	/**
	 * 
	 **/
	public static final class Partner {
	
	
	
	
		private final String partnerId;
		
	
		private Partner (
			final String partnerId)
			
		{
			this.partnerId = partnerId;
			
		}
		
		/**
		 * 
	      * @return The final value of partnerId on the object
		 **/
		public String getPartnerId() {
			return this.partnerId;
		}
		
	
		public static class Builder {
			private String partnerId;
			
			public Builder() {
				this.partnerId = "";
				
			}
			
			/**
			  * Adds a value to the builder for partnerId
			  * @param partnerId Value to assign to the mutable Builder
			  * @return The Builder instance so that call chaining works
			 **/
			public Builder setPartnerId(String partnerId) {
				this.partnerId = partnerId;
				return this;
			}
			
			/**
			  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
			  * of the Partner class
			  * @return The instantiated final Partner
			 **/
			public Partner build() {
				return new Partner(
					this.partnerId);
			}
		}
	
		/**
		 * Returns a Builder for Partner, which is a mutable representation of the object.  Once the
		 * client has built up an object they can then create an immutable Partner object using the
		 * build function.
		 * @return A fresh Builder instance with no values set
		 **/
		public static Builder newBuilder() {
			return new Builder();
		}
	
		/**
		 * Provides a human-readable representation of this object.  Useful for debugging.
		 * @return A string representation of the Partner instance
		 **/
		 public String toString() {
			 String result = "Partner\n";
			 result += "-> partnerId: (String)"
			     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.partnerId).split("\n"))) + "\n"; 
			 
			 return result;
		 }
		/**
		* Allows for simple conversion between the low-level generated protobuf object to
		* Partner, which is much more usable.
		* @return An instance of Partner representing the input proto object
		**/
		public static Partner fromProto(ServiceProviderProto.ServiceContext.Partner proto) {
			Partner out = null;
			if (proto != null) {
				Partner.Builder outBuilder = Partner.newBuilder()
				.setPartnerId(proto.getPartnerId());
				out = outBuilder.build();
			}
			return out;
		}
	
		/**
		* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
		* and returns a list of the converted results.
		* @return A list of Partner instances representing the input proto objects
		**/
		public static List<Partner> fromProtos(List<ServiceProviderProto.ServiceContext.Partner> protos) {
			List<Partner> out = new ArrayList<Partner>();
			for(ServiceProviderProto.ServiceContext.Partner proto : protos) {
				out.add(Partner.fromProto(proto));
			}
			return out;
		}
	
		/**
		 * Allows for simple conversion of an object to the low-level generated protobuf object.
		 * @return An instance of ServiceProviderProto.ServiceContext.Partner which is a proto object ready for wire transmission
		 **/
		 public ServiceProviderProto.ServiceContext.Partner toProto() {
			 Partner obj = this;
			 ServiceProviderProto.ServiceContext.Partner.Builder outBuilder = ServiceProviderProto.ServiceContext.Partner.newBuilder();
			 outBuilder.setPartnerId(obj.getPartnerId());
			 return outBuilder.build();
		 }
	
		 /**
		  * Convenience method for handling lists of objects.  It calls .toProto on each one and
		  * returns a list of the converted results.
		  * @return A list of ServiceProviderProto.ServiceContext.Partner instances representing the input objects.
		  */
		public static List<ServiceProviderProto.ServiceContext.Partner> toProtos(List<Partner> objects) {
			List<ServiceProviderProto.ServiceContext.Partner> out = new ArrayList<ServiceProviderProto.ServiceContext.Partner>();
			if(objects != null) {
				for (Partner obj : objects) {
					out.add(obj!=null?obj.toProto():null);
				}
			}
			return out;
		}
	}
	/**
	 * 
	 **/
	public static final class Brand {
	
	
	
	
		private final String groupPath;
		
	
		private Brand (
			final String groupPath)
			
		{
			this.groupPath = groupPath;
			
		}
		
		/**
		 * 
	      * @return The final value of groupPath on the object
		 **/
		public String getGroupPath() {
			return this.groupPath;
		}
		
	
		public static class Builder {
			private String groupPath;
			
			public Builder() {
				this.groupPath = "";
				
			}
			
			/**
			  * Adds a value to the builder for groupPath
			  * @param groupPath Value to assign to the mutable Builder
			  * @return The Builder instance so that call chaining works
			 **/
			public Builder setGroupPath(String groupPath) {
				this.groupPath = groupPath;
				return this;
			}
			
			/**
			  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
			  * of the Brand class
			  * @return The instantiated final Brand
			 **/
			public Brand build() {
				return new Brand(
					this.groupPath);
			}
		}
	
		/**
		 * Returns a Builder for Brand, which is a mutable representation of the object.  Once the
		 * client has built up an object they can then create an immutable Brand object using the
		 * build function.
		 * @return A fresh Builder instance with no values set
		 **/
		public static Builder newBuilder() {
			return new Builder();
		}
	
		/**
		 * Provides a human-readable representation of this object.  Useful for debugging.
		 * @return A string representation of the Brand instance
		 **/
		 public String toString() {
			 String result = "Brand\n";
			 result += "-> groupPath: (String)"
			     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.groupPath).split("\n"))) + "\n"; 
			 
			 return result;
		 }
		/**
		* Allows for simple conversion between the low-level generated protobuf object to
		* Brand, which is much more usable.
		* @return An instance of Brand representing the input proto object
		**/
		public static Brand fromProto(ServiceProviderProto.ServiceContext.Brand proto) {
			Brand out = null;
			if (proto != null) {
				Brand.Builder outBuilder = Brand.newBuilder()
				.setGroupPath(proto.getGroupPath());
				out = outBuilder.build();
			}
			return out;
		}
	
		/**
		* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
		* and returns a list of the converted results.
		* @return A list of Brand instances representing the input proto objects
		**/
		public static List<Brand> fromProtos(List<ServiceProviderProto.ServiceContext.Brand> protos) {
			List<Brand> out = new ArrayList<Brand>();
			for(ServiceProviderProto.ServiceContext.Brand proto : protos) {
				out.add(Brand.fromProto(proto));
			}
			return out;
		}
	
		/**
		 * Allows for simple conversion of an object to the low-level generated protobuf object.
		 * @return An instance of ServiceProviderProto.ServiceContext.Brand which is a proto object ready for wire transmission
		 **/
		 public ServiceProviderProto.ServiceContext.Brand toProto() {
			 Brand obj = this;
			 ServiceProviderProto.ServiceContext.Brand.Builder outBuilder = ServiceProviderProto.ServiceContext.Brand.newBuilder();
			 outBuilder.setGroupPath(obj.getGroupPath());
			 return outBuilder.build();
		 }
	
		 /**
		  * Convenience method for handling lists of objects.  It calls .toProto on each one and
		  * returns a list of the converted results.
		  * @return A list of ServiceProviderProto.ServiceContext.Brand instances representing the input objects.
		  */
		public static List<ServiceProviderProto.ServiceContext.Brand> toProtos(List<Brand> objects) {
			List<ServiceProviderProto.ServiceContext.Brand> out = new ArrayList<ServiceProviderProto.ServiceContext.Brand>();
			if(objects != null) {
				for (Brand obj : objects) {
					out.add(obj!=null?obj.toProto():null);
				}
			}
			return out;
		}
	}
	/**
	 * 
	 **/
	public static final class SuperAdmin {
	
	
	
	
		
	
		private SuperAdmin ()
			
		{
			
		}
		
	
		public static class Builder {
			
			public Builder() {
				
			}
			
			/**
			  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
			  * of the SuperAdmin class
			  * @return The instantiated final SuperAdmin
			 **/
			public SuperAdmin build() {
				return new SuperAdmin();
			}
		}
	
		/**
		 * Returns a Builder for SuperAdmin, which is a mutable representation of the object.  Once the
		 * client has built up an object they can then create an immutable SuperAdmin object using the
		 * build function.
		 * @return A fresh Builder instance with no values set
		 **/
		public static Builder newBuilder() {
			return new Builder();
		}
	
		/**
		 * Provides a human-readable representation of this object.  Useful for debugging.
		 * @return A string representation of the SuperAdmin instance
		 **/
		 public String toString() {
			 String result = "SuperAdmin\n";
			 
			 return result;
		 }
		/**
		* Allows for simple conversion between the low-level generated protobuf object to
		* SuperAdmin, which is much more usable.
		* @return An instance of SuperAdmin representing the input proto object
		**/
		public static SuperAdmin fromProto(ServiceProviderProto.ServiceContext.SuperAdmin proto) {
			SuperAdmin out = null;
			if (proto != null) {
				SuperAdmin.Builder outBuilder = SuperAdmin.newBuilder();
				out = outBuilder.build();
			}
			return out;
		}
	
		/**
		* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
		* and returns a list of the converted results.
		* @return A list of SuperAdmin instances representing the input proto objects
		**/
		public static List<SuperAdmin> fromProtos(List<ServiceProviderProto.ServiceContext.SuperAdmin> protos) {
			List<SuperAdmin> out = new ArrayList<SuperAdmin>();
			for(ServiceProviderProto.ServiceContext.SuperAdmin proto : protos) {
				out.add(SuperAdmin.fromProto(proto));
			}
			return out;
		}
	
		/**
		 * Allows for simple conversion of an object to the low-level generated protobuf object.
		 * @return An instance of ServiceProviderProto.ServiceContext.SuperAdmin which is a proto object ready for wire transmission
		 **/
		 public ServiceProviderProto.ServiceContext.SuperAdmin toProto() {
			 SuperAdmin obj = this;
			 ServiceProviderProto.ServiceContext.SuperAdmin.Builder outBuilder = ServiceProviderProto.ServiceContext.SuperAdmin.newBuilder();
			 return outBuilder.build();
		 }
	
		 /**
		  * Convenience method for handling lists of objects.  It calls .toProto on each one and
		  * returns a list of the converted results.
		  * @return A list of ServiceProviderProto.ServiceContext.SuperAdmin instances representing the input objects.
		  */
		public static List<ServiceProviderProto.ServiceContext.SuperAdmin> toProtos(List<SuperAdmin> objects) {
			List<ServiceProviderProto.ServiceContext.SuperAdmin> out = new ArrayList<ServiceProviderProto.ServiceContext.SuperAdmin>();
			if(objects != null) {
				for (SuperAdmin obj : objects) {
					out.add(obj!=null?obj.toProto():null);
				}
			}
			return out;
		}
	}

	private final ServiceContext.Account account;
	private final ServiceContext.Partner partner;
	private final ServiceContext.SuperAdmin superAdmin;
	private final ServiceContext.Brand brand;
	

	private ServiceContext (
		final ServiceContext.Account account,
		final ServiceContext.Partner partner,
		final ServiceContext.SuperAdmin superAdmin,
		final ServiceContext.Brand brand)
		
	{
		this.account = account;
		this.partner = partner;
		this.superAdmin = superAdmin;
		this.brand = brand;
		
	}
	
	/**
	 * 
      * @return The final value of account on the object
	 **/
	public ServiceContext.Account getAccount() {
		return this.account;
	}
	
	/**
	 * 
      * @return The final value of partner on the object
	 **/
	public ServiceContext.Partner getPartner() {
		return this.partner;
	}
	
	/**
	 * 
      * @return The final value of superAdmin on the object
	 **/
	public ServiceContext.SuperAdmin getSuperAdmin() {
		return this.superAdmin;
	}
	
	/**
	 * 
      * @return The final value of brand on the object
	 **/
	public ServiceContext.Brand getBrand() {
		return this.brand;
	}
	

	public static class Builder {
		private ServiceContext.Account account;
		private ServiceContext.Partner partner;
		private ServiceContext.SuperAdmin superAdmin;
		private ServiceContext.Brand brand;
		
		public Builder() {
			this.account = null;
			this.partner = null;
			this.superAdmin = null;
			this.brand = null;
			
		}
		
		/**
		  * Adds a value to the builder for account
		  * @param account Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setAccount(ServiceContext.Account account) {
			this.account = account;
			return this;
		}
		
		/**
		  * Adds a value to the builder for partner
		  * @param partner Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setPartner(ServiceContext.Partner partner) {
			this.partner = partner;
			return this;
		}
		
		/**
		  * Adds a value to the builder for superAdmin
		  * @param superAdmin Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setSuperAdmin(ServiceContext.SuperAdmin superAdmin) {
			this.superAdmin = superAdmin;
			return this;
		}
		
		/**
		  * Adds a value to the builder for brand
		  * @param brand Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setBrand(ServiceContext.Brand brand) {
			this.brand = brand;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the ServiceContext class
		  * @return The instantiated final ServiceContext
		 **/
		public ServiceContext build() {
			return new ServiceContext(
				this.account,
				this.partner,
				this.superAdmin,
				this.brand);
		}
	}

	/**
	 * Returns a Builder for ServiceContext, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable ServiceContext object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the ServiceContext instance
	 **/
	 public String toString() {
		 String result = "ServiceContext\n";
		 result += "-> account: (ServiceContext.Account)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.account).split("\n"))) + "\n"; 
		 result += "-> partner: (ServiceContext.Partner)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.partner).split("\n"))) + "\n"; 
		 result += "-> superAdmin: (ServiceContext.SuperAdmin)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.superAdmin).split("\n"))) + "\n"; 
		 result += "-> brand: (ServiceContext.Brand)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.brand).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* ServiceContext, which is much more usable.
	* @return An instance of ServiceContext representing the input proto object
	**/
	public static ServiceContext fromProto(ServiceProviderProto.ServiceContext proto) {
		ServiceContext out = null;
		if (proto != null) {
			ServiceContext.Builder outBuilder = ServiceContext.newBuilder()
			.setAccount(ServiceContext.Account.fromProto(proto.getAccount()))
			.setPartner(ServiceContext.Partner.fromProto(proto.getPartner()))
			.setSuperAdmin(ServiceContext.SuperAdmin.fromProto(proto.getSuperAdmin()))
			.setBrand(ServiceContext.Brand.fromProto(proto.getBrand()));
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of ServiceContext instances representing the input proto objects
	**/
	public static List<ServiceContext> fromProtos(List<ServiceProviderProto.ServiceContext> protos) {
		List<ServiceContext> out = new ArrayList<ServiceContext>();
		for(ServiceProviderProto.ServiceContext proto : protos) {
			out.add(ServiceContext.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ServiceProviderProto.ServiceContext which is a proto object ready for wire transmission
	 **/
	 public ServiceProviderProto.ServiceContext toProto() {
		 ServiceContext obj = this;
		 ServiceProviderProto.ServiceContext.Builder outBuilder = ServiceProviderProto.ServiceContext.newBuilder();
		 if(obj.getAccount() != null){outBuilder.setAccount(obj.getAccount().toProto());}
		 if(obj.getPartner() != null){outBuilder.setPartner(obj.getPartner().toProto());}
		 if(obj.getSuperAdmin() != null){outBuilder.setSuperAdmin(obj.getSuperAdmin().toProto());}
		 if(obj.getBrand() != null){outBuilder.setBrand(obj.getBrand().toProto());}
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ServiceProviderProto.ServiceContext instances representing the input objects.
	  */
	public static List<ServiceProviderProto.ServiceContext> toProtos(List<ServiceContext> objects) {
		List<ServiceProviderProto.ServiceContext> out = new ArrayList<ServiceProviderProto.ServiceContext>();
		if(objects != null) {
			for (ServiceContext obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}