package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ServiceProviderAdminProto;

/**
 * 
 **/
public final class ServiceProviderConfig {




	private final String serviceProviderId;
	private final String entryUrl;
	private final String sessionUrl;
	private final String primaryDomain;
	private final List<String> alternativeDomains;
	private final boolean ownedAndOperated;
	private final String logoutUrl;
	

	private ServiceProviderConfig (
		final String serviceProviderId,
		final String entryUrl,
		final String sessionUrl,
		final String primaryDomain,
		final List<String> alternativeDomains,
		final boolean ownedAndOperated,
		final String logoutUrl)
		
	{
		this.serviceProviderId = serviceProviderId;
		this.entryUrl = entryUrl;
		this.sessionUrl = sessionUrl;
		this.primaryDomain = primaryDomain;
		this.alternativeDomains = alternativeDomains;
		this.ownedAndOperated = ownedAndOperated;
		this.logoutUrl = logoutUrl;
		
	}
	
	/**
	 * Identifier of a service provider
      * @return The final value of serviceProviderId on the object
	 **/
	public String getServiceProviderId() {
		return this.serviceProviderId;
	}
	
	/**
	 * The entry url of the application, must handle a code on the request.
      * @return The final value of entryUrl on the object
	 **/
	public String getEntryUrl() {
		return this.entryUrl;
	}
	
	/**
	 * The url to be called to get a code for entering the application
      * @return The final value of sessionUrl on the object
	 **/
	public String getSessionUrl() {
		return this.sessionUrl;
	}
	
	/**
	 * The base url for the service provider
      * @return The final value of primaryDomain on the object
	 **/
	public String getPrimaryDomain() {
		return this.primaryDomain;
	}
	
	/**
	 * Alternative domains for a service provider
      * @return The final value of alternativeDomains on the object
	 **/
	public List<String> getAlternativeDomains() {
		return this.alternativeDomains;
	}
	
	/**
	 * Denotes whether or not a service provider is owned and operated by Vendasta
      * @return The final value of ownedAndOperated on the object
	 **/
	public boolean getOwnedAndOperated() {
		return this.ownedAndOperated;
	}
	
	/**
	 * The url to be called when a user logs out
      * @return The final value of logoutUrl on the object
	 **/
	public String getLogoutUrl() {
		return this.logoutUrl;
	}
	

	public static class Builder {
		private String serviceProviderId;
		private String entryUrl;
		private String sessionUrl;
		private String primaryDomain;
		private List<String> alternativeDomains;
		private boolean ownedAndOperated;
		private String logoutUrl;
		
		public Builder() {
			this.serviceProviderId = "";
			this.entryUrl = "";
			this.sessionUrl = "";
			this.primaryDomain = "";
			this.alternativeDomains = new ArrayList<String>();
			this.ownedAndOperated = false;
			this.logoutUrl = "";
			
		}
		
		/**
		  * Adds a value to the builder for serviceProviderId
		  * @param serviceProviderId Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProviderId(String serviceProviderId) {
			this.serviceProviderId = serviceProviderId;
			return this;
		}
		
		/**
		  * Adds a value to the builder for entryUrl
		  * @param entryUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setEntryUrl(String entryUrl) {
			this.entryUrl = entryUrl;
			return this;
		}
		
		/**
		  * Adds a value to the builder for sessionUrl
		  * @param sessionUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setSessionUrl(String sessionUrl) {
			this.sessionUrl = sessionUrl;
			return this;
		}
		
		/**
		  * Adds a value to the builder for primaryDomain
		  * @param primaryDomain Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setPrimaryDomain(String primaryDomain) {
			this.primaryDomain = primaryDomain;
			return this;
		}
		
		/**
		  * Adds a value to the builder for alternativeDomains
		  * @param alternativeDomains Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setAlternativeDomains(List<String> alternativeDomains) {
			this.alternativeDomains = alternativeDomains;
			return this;
		}
		
		/**
		  * Adds a value to the builder for ownedAndOperated
		  * @param ownedAndOperated Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setOwnedAndOperated(boolean ownedAndOperated) {
			this.ownedAndOperated = ownedAndOperated;
			return this;
		}
		
		/**
		  * Adds a value to the builder for logoutUrl
		  * @param logoutUrl Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setLogoutUrl(String logoutUrl) {
			this.logoutUrl = logoutUrl;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the ServiceProviderConfig class
		  * @return The instantiated final ServiceProviderConfig
		 **/
		public ServiceProviderConfig build() {
			return new ServiceProviderConfig(
				this.serviceProviderId,
				this.entryUrl,
				this.sessionUrl,
				this.primaryDomain,
				this.alternativeDomains,
				this.ownedAndOperated,
				this.logoutUrl);
		}
	}

	/**
	 * Returns a Builder for ServiceProviderConfig, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable ServiceProviderConfig object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the ServiceProviderConfig instance
	 **/
	 public String toString() {
		 String result = "ServiceProviderConfig\n";
		 result += "-> serviceProviderId: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))) + "\n"; 
		 result += "-> entryUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.entryUrl).split("\n"))) + "\n"; 
		 result += "-> sessionUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.sessionUrl).split("\n"))) + "\n"; 
		 result += "-> primaryDomain: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.primaryDomain).split("\n"))) + "\n"; 
		 result += "-> alternativeDomains: (List<String>)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.alternativeDomains).split("\n"))) + "\n"; 
		 result += "-> ownedAndOperated: (boolean)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.ownedAndOperated).split("\n"))) + "\n"; 
		 result += "-> logoutUrl: (String)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.logoutUrl).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* ServiceProviderConfig, which is much more usable.
	* @return An instance of ServiceProviderConfig representing the input proto object
	**/
	public static ServiceProviderConfig fromProto(ServiceProviderAdminProto.ServiceProviderConfig proto) {
		ServiceProviderConfig out = null;
		if (proto != null) {
			ServiceProviderConfig.Builder outBuilder = ServiceProviderConfig.newBuilder()
			.setServiceProviderId(proto.getServiceProviderId())
			.setEntryUrl(proto.getEntryUrl())
			.setSessionUrl(proto.getSessionUrl())
			.setPrimaryDomain(proto.getPrimaryDomain())
			.setAlternativeDomains(proto.getAlternativeDomainsList())
			.setOwnedAndOperated(proto.getOwnedAndOperated())
			.setLogoutUrl(proto.getLogoutUrl());
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of ServiceProviderConfig instances representing the input proto objects
	**/
	public static List<ServiceProviderConfig> fromProtos(List<ServiceProviderAdminProto.ServiceProviderConfig> protos) {
		List<ServiceProviderConfig> out = new ArrayList<ServiceProviderConfig>();
		for(ServiceProviderAdminProto.ServiceProviderConfig proto : protos) {
			out.add(ServiceProviderConfig.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ServiceProviderAdminProto.ServiceProviderConfig which is a proto object ready for wire transmission
	 **/
	 public ServiceProviderAdminProto.ServiceProviderConfig toProto() {
		 ServiceProviderConfig obj = this;
		 ServiceProviderAdminProto.ServiceProviderConfig.Builder outBuilder = ServiceProviderAdminProto.ServiceProviderConfig.newBuilder();
		 outBuilder.setServiceProviderId(obj.getServiceProviderId());
		 outBuilder.setEntryUrl(obj.getEntryUrl());
		 outBuilder.setSessionUrl(obj.getSessionUrl());
		 outBuilder.setPrimaryDomain(obj.getPrimaryDomain());
		 outBuilder.addAllAlternativeDomains(obj.getAlternativeDomains());
		 outBuilder.setOwnedAndOperated(obj.getOwnedAndOperated());
		 outBuilder.setLogoutUrl(obj.getLogoutUrl());
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ServiceProviderAdminProto.ServiceProviderConfig instances representing the input objects.
	  */
	public static List<ServiceProviderAdminProto.ServiceProviderConfig> toProtos(List<ServiceProviderConfig> objects) {
		List<ServiceProviderAdminProto.ServiceProviderConfig> out = new ArrayList<ServiceProviderAdminProto.ServiceProviderConfig>();
		if(objects != null) {
			for (ServiceProviderConfig obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}