package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class UpdateServiceProviderRequest {




	private final ServiceProviderConfig serviceProvider;
	

	private UpdateServiceProviderRequest (
		final ServiceProviderConfig serviceProvider)
		
	{
		this.serviceProvider = serviceProvider;
		
	}
	
	/**
	 * 
      * @return The final value of serviceProvider on the object
	 **/
	public ServiceProviderConfig getServiceProvider() {
		return this.serviceProvider;
	}
	

	public static class Builder {
		private ServiceProviderConfig serviceProvider;
		
		public Builder() {
			this.serviceProvider = null;
			
		}
		
		/**
		  * Adds a value to the builder for serviceProvider
		  * @param serviceProvider Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProvider(ServiceProviderConfig serviceProvider) {
			this.serviceProvider = serviceProvider;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the UpdateServiceProviderRequest class
		  * @return The instantiated final UpdateServiceProviderRequest
		 **/
		public UpdateServiceProviderRequest build() {
			return new UpdateServiceProviderRequest(
				this.serviceProvider);
		}
	}

	/**
	 * Returns a Builder for UpdateServiceProviderRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable UpdateServiceProviderRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the UpdateServiceProviderRequest instance
	 **/
	 public String toString() {
		 String result = "UpdateServiceProviderRequest\n";
		 result += "-> serviceProvider: (ServiceProviderConfig)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProvider).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* UpdateServiceProviderRequest, which is much more usable.
	* @return An instance of UpdateServiceProviderRequest representing the input proto object
	**/
	public static UpdateServiceProviderRequest fromProto(ApiProto.UpdateServiceProviderRequest proto) {
		UpdateServiceProviderRequest out = null;
		if (proto != null) {
			UpdateServiceProviderRequest.Builder outBuilder = UpdateServiceProviderRequest.newBuilder()
			.setServiceProvider(ServiceProviderConfig.fromProto(proto.getServiceProvider()));
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of UpdateServiceProviderRequest instances representing the input proto objects
	**/
	public static List<UpdateServiceProviderRequest> fromProtos(List<ApiProto.UpdateServiceProviderRequest> protos) {
		List<UpdateServiceProviderRequest> out = new ArrayList<UpdateServiceProviderRequest>();
		for(ApiProto.UpdateServiceProviderRequest proto : protos) {
			out.add(UpdateServiceProviderRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.UpdateServiceProviderRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.UpdateServiceProviderRequest toProto() {
		 UpdateServiceProviderRequest obj = this;
		 ApiProto.UpdateServiceProviderRequest.Builder outBuilder = ApiProto.UpdateServiceProviderRequest.newBuilder();
		 if(obj.getServiceProvider() != null){outBuilder.setServiceProvider(obj.getServiceProvider().toProto());}
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.UpdateServiceProviderRequest instances representing the input objects.
	  */
	public static List<ApiProto.UpdateServiceProviderRequest> toProtos(List<UpdateServiceProviderRequest> objects) {
		List<ApiProto.UpdateServiceProviderRequest> out = new ArrayList<ApiProto.UpdateServiceProviderRequest>();
		if(objects != null) {
			for (UpdateServiceProviderRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}