/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.vendasta.sso.v1.internal.GetEntryURLRequest;
import com.vendasta.sso.v1.internal.GetEntryURLResponse;
import com.vendasta.sso.v1.internal.GetEntryURLWithCodeRequest;
import com.vendasta.sso.v1.internal.GetEntryURLWithCodeResponse;
import com.vendasta.sso.v1.internal.IdentityProviderGeneratedClient;
import com.vendasta.sso.v1.internal.LogoutRequest;
import com.vendasta.sso.v1.internal.ServiceContext;
import com.vendasta.vax.Environment;
import com.vendasta.vax.SDKException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;

public class IdentityProviderClient
extends IdentityProviderGeneratedClient {
    private static Gson gson = new Gson();

    public IdentityProviderClient(Environment environment) {
        super(environment);
    }

    public IdentityProviderClient(Environment environment, float defaultTimeout) {
        super(environment, defaultTimeout);
    }

    public IdentityProviderClient(Environment environment, InputStream serviceAccount, float defaultTimeout) {
        super(environment, serviceAccount, defaultTimeout);
    }

    public IdentityProviderClient(Environment environment, InputStream serviceAccount, IdentityProviderGeneratedClient.Options options) {
        super(environment, serviceAccount, options);
    }

    public String getEntryURL(String serviceProviderID, String encodedContext) throws SDKException {
        ServiceContext decodedContext = new ServiceContext(encodedContext);
        if (decodedContext.getAccountContext() != null) {
            return this.getEntryURL(serviceProviderID, decodedContext.getAccountContext());
        }
        if (decodedContext.getPartnerContext() != null) {
            return this.getEntryURL(serviceProviderID, decodedContext.getPartnerContext());
        }
        throw new UnknownContextException("unknown context");
    }

    public String getEntryURL(String serviceProviderID, AccountContext context) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setAccount(ServiceContext.Account.newBuilder().setAccountId(context.getAccountId()).build()).build();
        return this.getEntryURL(serviceProviderID, serviceContext);
    }

    public String getEntryURL(String serviceProviderID, BrandContext context) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setBrand(ServiceContext.Brand.newBuilder().setGroupPath(context.getGroupPath()).build()).build();
        return this.getEntryURL(serviceProviderID, serviceContext);
    }

    public String getEntryURL(String serviceProviderID, PartnerContext context) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setPartner(ServiceContext.Partner.newBuilder().setPartnerId(context.getPartnerId()).build()).build();
        return this.getEntryURL(serviceProviderID, serviceContext);
    }

    private String getEntryURL(String serviceProviderID, com.vendasta.sso.v1.internal.ServiceContext context) throws SDKException {
        GetEntryURLRequest request = GetEntryURLRequest.newBuilder().setServiceProviderId(serviceProviderID).setContext(context).build();
        GetEntryURLResponse resp = this.GetEntryURL(request, null);
        return resp.getEntryUrl();
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, String encodedContext, String nextURL) throws SDKException {
        ServiceContext decodedContext = new ServiceContext(encodedContext);
        if (decodedContext.getAccountContext() != null) {
            return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, decodedContext.getAccountContext(), nextURL);
        }
        if (decodedContext.getPartnerContext() != null) {
            return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, decodedContext.getPartnerContext(), nextURL);
        }
        if (decodedContext.getBrandContext() != null) {
            return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, decodedContext.getBrandContext(), nextURL);
        }
        throw new UnknownContextException("unknown context");
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, String encodedContext, String nextURL, String backUrl, String backUrlText) throws SDKException {
        ServiceContext decodedContext = new ServiceContext(encodedContext);
        if (decodedContext.getAccountContext() != null) {
            return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, decodedContext.getAccountContext(), nextURL, backUrl, backUrlText);
        }
        if (decodedContext.getPartnerContext() != null) {
            return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, decodedContext.getPartnerContext(), nextURL, backUrl, backUrlText);
        }
        if (decodedContext.getBrandContext() != null) {
            return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, decodedContext.getBrandContext(), nextURL, backUrl, backUrlText);
        }
        throw new UnknownContextException("unknown context");
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, AccountContext context, String nextURL) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setAccount(ServiceContext.Account.newBuilder().setAccountId(context.getAccountId()).build()).build();
        return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, serviceContext, nextURL, "", "");
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, AccountContext context, String nextURL, String backUrl, String backUrlText) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setAccount(ServiceContext.Account.newBuilder().setAccountId(context.getAccountId()).build()).build();
        return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, serviceContext, nextURL, backUrl, backUrlText);
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, PartnerContext context, String nextURL) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setPartner(ServiceContext.Partner.newBuilder().setPartnerId(context.getPartnerId()).build()).build();
        return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, serviceContext, nextURL, "", "");
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, PartnerContext context, String nextURL, String backUrl, String backUrlText) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setPartner(ServiceContext.Partner.newBuilder().setPartnerId(context.getPartnerId()).build()).build();
        return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, serviceContext, nextURL, backUrl, backUrlText);
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, BrandContext context, String nextURL) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setBrand(ServiceContext.Brand.newBuilder().setGroupPath(context.getGroupPath()).build()).build();
        return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, serviceContext, nextURL, "", "");
    }

    public String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, BrandContext context, String nextURL, String backUrl, String backUrlText) throws SDKException {
        com.vendasta.sso.v1.internal.ServiceContext serviceContext = com.vendasta.sso.v1.internal.ServiceContext.newBuilder().setBrand(ServiceContext.Brand.newBuilder().setGroupPath(context.getGroupPath()).build()).build();
        return this.getEntryURLWithCode(serviceProviderID, sessionID, userID, email, serviceContext, nextURL, backUrl, backUrlText);
    }

    private String getEntryURLWithCode(String serviceProviderID, String sessionID, String userID, String email, com.vendasta.sso.v1.internal.ServiceContext serviceContext, String nextURL, String backUrl, String backUrlText) throws SDKException {
        GetEntryURLWithCodeRequest request = GetEntryURLWithCodeRequest.newBuilder().setServiceProviderId(serviceProviderID).setSessionId(sessionID).setUserId(userID).setEmail(email).setContext(serviceContext).setNextUrl(nextURL).setBackUrl(backUrl).setBackUrlText(backUrlText).build();
        GetEntryURLWithCodeResponse response = this.GetEntryURLWithCode(request, null);
        return response.getEntryUrl();
    }

    public void logout(String sessionID) throws SDKException {
        LogoutRequest request = LogoutRequest.newBuilder().setSessionId(sessionID).build();
        this.Logout(request, null);
    }

    public class SessionNotFoundException
    extends SDKException {
        public SessionNotFoundException() {
            super("Session not found for the given session ID.");
        }
    }

    public class InvalidContextException
    extends SDKException {
        public InvalidContextException() {
            super("Invalid context. The context may not be valid json, or it may be missing the '_type' field");
        }
    }

    public class JsonParseException
    extends SDKException {
        public JsonParseException(String message) {
            super(message);
        }
    }

    public class UnknownContextException
    extends SDKException {
        public UnknownContextException(String message) {
            super(message);
        }
    }

    public final class ServiceContext {
        private AccountContext accountContext;
        private PartnerContext partnerContext;
        private BrandContext brandContext;

        public AccountContext getAccountContext() {
            return this.accountContext;
        }

        public PartnerContext getPartnerContext() {
            return this.partnerContext;
        }

        public BrandContext getBrandContext() {
            return this.brandContext;
        }

        public ServiceContext(String b64EncodedContext) {
            block5: {
                this.accountContext = null;
                this.partnerContext = null;
                this.brandContext = null;
                String decoded = new String(Base64.decodeBase64((byte[])b64EncodedContext.getBytes()));
                try {
                    String type = this.determineContextType(decoded);
                    if (type.equals("account")) {
                        this.accountContext = (AccountContext)gson.fromJson(decoded, AccountContext.class);
                        break block5;
                    }
                    if (type.equals("partner")) {
                        this.partnerContext = (PartnerContext)gson.fromJson(decoded, PartnerContext.class);
                        break block5;
                    }
                    if (type.equals("brand")) {
                        this.brandContext = (BrandContext)gson.fromJson(decoded, BrandContext.class);
                        break block5;
                    }
                    throw new UnknownContextException("unknown context: " + type);
                }
                catch (JsonSyntaxException e) {
                    throw new JsonParseException("unable to parse json for context: " + b64EncodedContext);
                }
            }
        }

        private String determineContextType(String json) throws InvalidContextException {
            Gson gson = new Gson();
            ContextType ctype = (ContextType)gson.fromJson(json, ContextType.class);
            if (ctype == null) {
                throw new InvalidContextException();
            }
            return ctype._type;
        }

        private class ContextType {
            private String _type;

            private ContextType() {
            }
        }
    }

    public static final class PartnerContext {
        @SerializedName(value="partner_id")
        private final String partnerId;

        public PartnerContext(String partnerId) {
            this.partnerId = partnerId;
        }

        public String getPartnerId() {
            return this.partnerId;
        }
    }

    public static final class BrandContext {
        @SerializedName(value="group_path")
        private final String groupPath;

        public BrandContext(String groupPath) {
            this.groupPath = groupPath;
        }

        public String getGroupPath() {
            return this.groupPath;
        }
    }

    public static final class AccountContext {
        @SerializedName(value="account_id")
        private final String accountId;

        public AccountContext(String accountId) {
            this.accountId = accountId;
        }

        public String getAccountId() {
            return this.accountId;
        }
    }
}

