/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1.internal;

import com.vendasta.sso.v1.generated.ApiProto;
import com.vendasta.sso.v1.internal.ServiceContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class GetEntryURLWithCodeRequest {
    private final String serviceProviderId;
    private final String sessionId;
    private final String userId;
    private final String email;
    private final ServiceContext context;
    private final String nextUrl;
    private final String backUrl;
    private final String backUrlText;
    private final String federatedIdentityProvider;

    private GetEntryURLWithCodeRequest(String serviceProviderId, String sessionId, String userId, String email, ServiceContext context, String nextUrl, String backUrl, String backUrlText, String federatedIdentityProvider) {
        this.serviceProviderId = serviceProviderId;
        this.sessionId = sessionId;
        this.userId = userId;
        this.email = email;
        this.context = context;
        this.nextUrl = nextUrl;
        this.backUrl = backUrl;
        this.backUrlText = backUrlText;
        this.federatedIdentityProvider = federatedIdentityProvider;
    }

    public String getServiceProviderId() {
        return this.serviceProviderId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public ServiceContext getContext() {
        return this.context;
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public String getBackUrl() {
        return this.backUrl;
    }

    public String getBackUrlText() {
        return this.backUrlText;
    }

    public String getFederatedIdentityProvider() {
        return this.federatedIdentityProvider;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        String result = "GetEntryURLWithCodeRequest\n";
        result = result + "-> serviceProviderId: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))}) + "\n";
        result = result + "-> sessionId: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.sessionId).split("\n"))}) + "\n";
        result = result + "-> userId: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.userId).split("\n"))}) + "\n";
        result = result + "-> email: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.email).split("\n"))}) + "\n";
        result = result + "-> context: (ServiceContext)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.context).split("\n"))}) + "\n";
        result = result + "-> nextUrl: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.nextUrl).split("\n"))}) + "\n";
        result = result + "-> backUrl: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.backUrl).split("\n"))}) + "\n";
        result = result + "-> backUrlText: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.backUrlText).split("\n"))}) + "\n";
        result = result + "-> federatedIdentityProvider: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.federatedIdentityProvider).split("\n"))}) + "\n";
        return result;
    }

    public static GetEntryURLWithCodeRequest fromProto(ApiProto.GetEntryURLWithCodeRequest proto) {
        GetEntryURLWithCodeRequest out = null;
        if (proto != null) {
            Builder outBuilder = GetEntryURLWithCodeRequest.newBuilder().setServiceProviderId(proto.getServiceProviderId()).setSessionId(proto.getSessionId()).setUserId(proto.getUserId()).setEmail(proto.getEmail()).setContext(ServiceContext.fromProto(proto.getContext())).setNextUrl(proto.getNextUrl()).setBackUrl(proto.getBackUrl()).setBackUrlText(proto.getBackUrlText()).setFederatedIdentityProvider(proto.getFederatedIdentityProvider());
            out = outBuilder.build();
        }
        return out;
    }

    public static List<GetEntryURLWithCodeRequest> fromProtos(List<ApiProto.GetEntryURLWithCodeRequest> protos) {
        ArrayList<GetEntryURLWithCodeRequest> out = new ArrayList<GetEntryURLWithCodeRequest>();
        for (ApiProto.GetEntryURLWithCodeRequest proto : protos) {
            out.add(GetEntryURLWithCodeRequest.fromProto(proto));
        }
        return out;
    }

    public ApiProto.GetEntryURLWithCodeRequest toProto() {
        GetEntryURLWithCodeRequest obj = this;
        ApiProto.GetEntryURLWithCodeRequest.Builder outBuilder = ApiProto.GetEntryURLWithCodeRequest.newBuilder();
        outBuilder.setServiceProviderId(obj.getServiceProviderId());
        outBuilder.setSessionId(obj.getSessionId());
        outBuilder.setUserId(obj.getUserId());
        outBuilder.setEmail(obj.getEmail());
        if (obj.getContext() != null) {
            outBuilder.setContext(obj.getContext().toProto());
        }
        outBuilder.setNextUrl(obj.getNextUrl());
        outBuilder.setBackUrl(obj.getBackUrl());
        outBuilder.setBackUrlText(obj.getBackUrlText());
        outBuilder.setFederatedIdentityProvider(obj.getFederatedIdentityProvider());
        return outBuilder.build();
    }

    public static List<ApiProto.GetEntryURLWithCodeRequest> toProtos(List<GetEntryURLWithCodeRequest> objects) {
        ArrayList<ApiProto.GetEntryURLWithCodeRequest> out = new ArrayList<ApiProto.GetEntryURLWithCodeRequest>();
        if (objects != null) {
            for (GetEntryURLWithCodeRequest obj : objects) {
                out.add(obj != null ? obj.toProto() : null);
            }
        }
        return out;
    }

    public static class Builder {
        private String serviceProviderId = "";
        private String sessionId = "";
        private String userId = "";
        private String email = "";
        private ServiceContext context = null;
        private String nextUrl = "";
        private String backUrl = "";
        private String backUrlText = "";
        private String federatedIdentityProvider = "";

        public Builder setServiceProviderId(String serviceProviderId) {
            this.serviceProviderId = serviceProviderId;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setContext(ServiceContext context) {
            this.context = context;
            return this;
        }

        public Builder setNextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public Builder setBackUrl(String backUrl) {
            this.backUrl = backUrl;
            return this;
        }

        public Builder setBackUrlText(String backUrlText) {
            this.backUrlText = backUrlText;
            return this;
        }

        public Builder setFederatedIdentityProvider(String federatedIdentityProvider) {
            this.federatedIdentityProvider = federatedIdentityProvider;
            return this;
        }

        public GetEntryURLWithCodeRequest build() {
            return new GetEntryURLWithCodeRequest(this.serviceProviderId, this.sessionId, this.userId, this.email, this.context, this.nextUrl, this.backUrl, this.backUrlText, this.federatedIdentityProvider);
        }
    }
}

