/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1.internal;

import com.google.protobuf.Empty;
import com.vendasta.sso.v1.Config;
import com.vendasta.sso.v1.internal.GetEntryURLRequest;
import com.vendasta.sso.v1.internal.GetEntryURLResponse;
import com.vendasta.sso.v1.internal.GetEntryURLWithCodeRequest;
import com.vendasta.sso.v1.internal.GetEntryURLWithCodeResponse;
import com.vendasta.sso.v1.internal.GetMultiEntryURLRequest;
import com.vendasta.sso.v1.internal.GetMultiEntryURLResponse;
import com.vendasta.sso.v1.internal.IdentityProviderClientInterface;
import com.vendasta.sso.v1.internal.IdentityProviderGRPCClient;
import com.vendasta.sso.v1.internal.IdentityProviderHTTPClient;
import com.vendasta.sso.v1.internal.LogoutRequest;
import com.vendasta.vax.Environment;
import com.vendasta.vax.EnvironmentConfig;
import com.vendasta.vax.RequestOptions;
import com.vendasta.vax.SDKException;
import java.io.InputStream;

public class IdentityProviderGeneratedClient
implements IdentityProviderClientInterface {
    private IdentityProviderClientInterface transport;

    public IdentityProviderGeneratedClient(Environment environment) {
        this(environment, 10000.0f);
    }

    public IdentityProviderGeneratedClient(Environment environment, Options options) {
        this.transport = this.getTransportClient(environment, options);
    }

    public IdentityProviderGeneratedClient(Environment environment, float defaultTimeout) {
        Options opts = new Options.Builder().setDefaultTimeout(Float.valueOf(defaultTimeout)).build();
        this.transport = this.getTransportClient(environment, opts);
    }

    public IdentityProviderGeneratedClient(Environment environment, InputStream serviceAccount, float defaultTimeout) {
        Options opts = new Options.Builder().setDefaultTimeout(Float.valueOf(defaultTimeout)).build();
        this.transport = this.getTransportClient(environment, serviceAccount, opts);
    }

    public IdentityProviderGeneratedClient(Environment environment, InputStream serviceAccount, Options options) {
        this.transport = this.getTransportClient(environment, serviceAccount, options);
    }

    private IdentityProviderClientInterface getTransportClient(Environment environment, Options options) {
        EnvironmentConfig config = Config.getEnvironmentConfig(environment);
        if (options.getUseHttp().booleanValue()) {
            return new IdentityProviderHTTPClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            return new IdentityProviderGRPCClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        catch (ClassNotFoundException e) {
            return new IdentityProviderHTTPClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
    }

    private IdentityProviderClientInterface getTransportClient(Environment environment, InputStream serviceAccount, Options options) {
        EnvironmentConfig config = Config.getEnvironmentConfig(environment);
        if (options.getUseHttp().booleanValue()) {
            return new IdentityProviderHTTPClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            return new IdentityProviderGRPCClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        catch (ClassNotFoundException e) {
            return new IdentityProviderHTTPClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
    }

    @Override
    public GetEntryURLResponse GetEntryURL(GetEntryURLRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.GetEntryURL(req, options);
    }

    @Override
    public GetMultiEntryURLResponse GetMultiEntryURL(GetMultiEntryURLRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.GetMultiEntryURL(req, options);
    }

    @Override
    public GetEntryURLWithCodeResponse GetEntryURLWithCode(GetEntryURLWithCodeRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.GetEntryURLWithCode(req, options);
    }

    @Override
    public Empty Logout(LogoutRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.Logout(req, options);
    }

    public static class Options {
        private Boolean useHttp = false;
        private float defaultTimeout = 10000.0f;

        Options(Builder builder) {
            if (builder.useHttp != null) {
                this.useHttp = builder.useHttp;
            }
            if (builder.defaultTimeout != null) {
                this.defaultTimeout = builder.defaultTimeout.floatValue();
            }
        }

        Boolean getUseHttp() {
            return this.useHttp;
        }

        Float getDefaultTimeout() {
            return Float.valueOf(this.defaultTimeout);
        }

        public static class Builder {
            private Boolean useHttp;
            private Float defaultTimeout;

            public static Builder newBuilder() {
                return new Builder();
            }

            public Builder useHttp() {
                this.useHttp = true;
                return this;
            }

            public Builder setDefaultTimeout(Float defaultTimeout) {
                this.defaultTimeout = defaultTimeout;
                return this;
            }

            public Options build() {
                return new Options(this);
            }
        }
    }
}

