/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1.internal;

import com.vendasta.sso.v1.generated.ServiceProviderProto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ServiceContext {
    private final Account account;
    private final Partner partner;
    private final SuperAdmin superAdmin;
    private final Brand brand;

    private ServiceContext(Account account, Partner partner, SuperAdmin superAdmin, Brand brand) {
        this.account = account;
        this.partner = partner;
        this.superAdmin = superAdmin;
        this.brand = brand;
    }

    public Account getAccount() {
        return this.account;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public SuperAdmin getSuperAdmin() {
        return this.superAdmin;
    }

    public Brand getBrand() {
        return this.brand;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        String result = "ServiceContext\n";
        result = result + "-> account: (ServiceContext.Account)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.account).split("\n"))}) + "\n";
        result = result + "-> partner: (ServiceContext.Partner)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.partner).split("\n"))}) + "\n";
        result = result + "-> superAdmin: (ServiceContext.SuperAdmin)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.superAdmin).split("\n"))}) + "\n";
        result = result + "-> brand: (ServiceContext.Brand)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.brand).split("\n"))}) + "\n";
        return result;
    }

    public static ServiceContext fromProto(ServiceProviderProto.ServiceContext proto) {
        ServiceContext out = null;
        if (proto != null) {
            Builder outBuilder = ServiceContext.newBuilder().setAccount(Account.fromProto(proto.getAccount())).setPartner(Partner.fromProto(proto.getPartner())).setSuperAdmin(SuperAdmin.fromProto(proto.getSuperAdmin())).setBrand(Brand.fromProto(proto.getBrand()));
            out = outBuilder.build();
        }
        return out;
    }

    public static List<ServiceContext> fromProtos(List<ServiceProviderProto.ServiceContext> protos) {
        ArrayList<ServiceContext> out = new ArrayList<ServiceContext>();
        for (ServiceProviderProto.ServiceContext proto : protos) {
            out.add(ServiceContext.fromProto(proto));
        }
        return out;
    }

    public ServiceProviderProto.ServiceContext toProto() {
        ServiceContext obj = this;
        ServiceProviderProto.ServiceContext.Builder outBuilder = ServiceProviderProto.ServiceContext.newBuilder();
        if (obj.getAccount() != null) {
            outBuilder.setAccount(obj.getAccount().toProto());
        }
        if (obj.getPartner() != null) {
            outBuilder.setPartner(obj.getPartner().toProto());
        }
        if (obj.getSuperAdmin() != null) {
            outBuilder.setSuperAdmin(obj.getSuperAdmin().toProto());
        }
        if (obj.getBrand() != null) {
            outBuilder.setBrand(obj.getBrand().toProto());
        }
        return outBuilder.build();
    }

    public static List<ServiceProviderProto.ServiceContext> toProtos(List<ServiceContext> objects) {
        ArrayList<ServiceProviderProto.ServiceContext> out = new ArrayList<ServiceProviderProto.ServiceContext>();
        if (objects != null) {
            for (ServiceContext obj : objects) {
                out.add(obj != null ? obj.toProto() : null);
            }
        }
        return out;
    }

    public static class Builder {
        private Account account = null;
        private Partner partner = null;
        private SuperAdmin superAdmin = null;
        private Brand brand = null;

        public Builder setAccount(Account account) {
            this.account = account;
            return this;
        }

        public Builder setPartner(Partner partner) {
            this.partner = partner;
            return this;
        }

        public Builder setSuperAdmin(SuperAdmin superAdmin) {
            this.superAdmin = superAdmin;
            return this;
        }

        public Builder setBrand(Brand brand) {
            this.brand = brand;
            return this;
        }

        public ServiceContext build() {
            return new ServiceContext(this.account, this.partner, this.superAdmin, this.brand);
        }
    }

    public static final class SuperAdmin {
        private SuperAdmin() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            String result = "SuperAdmin\n";
            return result;
        }

        public static SuperAdmin fromProto(ServiceProviderProto.ServiceContext.SuperAdmin proto) {
            SuperAdmin out = null;
            if (proto != null) {
                Builder outBuilder = SuperAdmin.newBuilder();
                out = outBuilder.build();
            }
            return out;
        }

        public static List<SuperAdmin> fromProtos(List<ServiceProviderProto.ServiceContext.SuperAdmin> protos) {
            ArrayList<SuperAdmin> out = new ArrayList<SuperAdmin>();
            for (ServiceProviderProto.ServiceContext.SuperAdmin proto : protos) {
                out.add(SuperAdmin.fromProto(proto));
            }
            return out;
        }

        public ServiceProviderProto.ServiceContext.SuperAdmin toProto() {
            SuperAdmin obj = this;
            ServiceProviderProto.ServiceContext.SuperAdmin.Builder outBuilder = ServiceProviderProto.ServiceContext.SuperAdmin.newBuilder();
            return outBuilder.build();
        }

        public static List<ServiceProviderProto.ServiceContext.SuperAdmin> toProtos(List<SuperAdmin> objects) {
            ArrayList<ServiceProviderProto.ServiceContext.SuperAdmin> out = new ArrayList<ServiceProviderProto.ServiceContext.SuperAdmin>();
            if (objects != null) {
                for (SuperAdmin obj : objects) {
                    out.add(obj != null ? obj.toProto() : null);
                }
            }
            return out;
        }

        public static class Builder {
            public SuperAdmin build() {
                return new SuperAdmin();
            }
        }
    }

    public static final class Brand {
        private final String groupPath;

        private Brand(String groupPath) {
            this.groupPath = groupPath;
        }

        public String getGroupPath() {
            return this.groupPath;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            String result = "Brand\n";
            result = result + "-> groupPath: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.groupPath).split("\n"))}) + "\n";
            return result;
        }

        public static Brand fromProto(ServiceProviderProto.ServiceContext.Brand proto) {
            Brand out = null;
            if (proto != null) {
                Builder outBuilder = Brand.newBuilder().setGroupPath(proto.getGroupPath());
                out = outBuilder.build();
            }
            return out;
        }

        public static List<Brand> fromProtos(List<ServiceProviderProto.ServiceContext.Brand> protos) {
            ArrayList<Brand> out = new ArrayList<Brand>();
            for (ServiceProviderProto.ServiceContext.Brand proto : protos) {
                out.add(Brand.fromProto(proto));
            }
            return out;
        }

        public ServiceProviderProto.ServiceContext.Brand toProto() {
            Brand obj = this;
            ServiceProviderProto.ServiceContext.Brand.Builder outBuilder = ServiceProviderProto.ServiceContext.Brand.newBuilder();
            outBuilder.setGroupPath(obj.getGroupPath());
            return outBuilder.build();
        }

        public static List<ServiceProviderProto.ServiceContext.Brand> toProtos(List<Brand> objects) {
            ArrayList<ServiceProviderProto.ServiceContext.Brand> out = new ArrayList<ServiceProviderProto.ServiceContext.Brand>();
            if (objects != null) {
                for (Brand obj : objects) {
                    out.add(obj != null ? obj.toProto() : null);
                }
            }
            return out;
        }

        public static class Builder {
            private String groupPath = "";

            public Builder setGroupPath(String groupPath) {
                this.groupPath = groupPath;
                return this;
            }

            public Brand build() {
                return new Brand(this.groupPath);
            }
        }
    }

    public static final class Partner {
        private final String partnerId;

        private Partner(String partnerId) {
            this.partnerId = partnerId;
        }

        public String getPartnerId() {
            return this.partnerId;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            String result = "Partner\n";
            result = result + "-> partnerId: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.partnerId).split("\n"))}) + "\n";
            return result;
        }

        public static Partner fromProto(ServiceProviderProto.ServiceContext.Partner proto) {
            Partner out = null;
            if (proto != null) {
                Builder outBuilder = Partner.newBuilder().setPartnerId(proto.getPartnerId());
                out = outBuilder.build();
            }
            return out;
        }

        public static List<Partner> fromProtos(List<ServiceProviderProto.ServiceContext.Partner> protos) {
            ArrayList<Partner> out = new ArrayList<Partner>();
            for (ServiceProviderProto.ServiceContext.Partner proto : protos) {
                out.add(Partner.fromProto(proto));
            }
            return out;
        }

        public ServiceProviderProto.ServiceContext.Partner toProto() {
            Partner obj = this;
            ServiceProviderProto.ServiceContext.Partner.Builder outBuilder = ServiceProviderProto.ServiceContext.Partner.newBuilder();
            outBuilder.setPartnerId(obj.getPartnerId());
            return outBuilder.build();
        }

        public static List<ServiceProviderProto.ServiceContext.Partner> toProtos(List<Partner> objects) {
            ArrayList<ServiceProviderProto.ServiceContext.Partner> out = new ArrayList<ServiceProviderProto.ServiceContext.Partner>();
            if (objects != null) {
                for (Partner obj : objects) {
                    out.add(obj != null ? obj.toProto() : null);
                }
            }
            return out;
        }

        public static class Builder {
            private String partnerId = "";

            public Builder setPartnerId(String partnerId) {
                this.partnerId = partnerId;
                return this;
            }

            public Partner build() {
                return new Partner(this.partnerId);
            }
        }
    }

    public static final class Account {
        private final String accountId;

        private Account(String accountId) {
            this.accountId = accountId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            String result = "Account\n";
            result = result + "-> accountId: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.accountId).split("\n"))}) + "\n";
            return result;
        }

        public static Account fromProto(ServiceProviderProto.ServiceContext.Account proto) {
            Account out = null;
            if (proto != null) {
                Builder outBuilder = Account.newBuilder().setAccountId(proto.getAccountId());
                out = outBuilder.build();
            }
            return out;
        }

        public static List<Account> fromProtos(List<ServiceProviderProto.ServiceContext.Account> protos) {
            ArrayList<Account> out = new ArrayList<Account>();
            for (ServiceProviderProto.ServiceContext.Account proto : protos) {
                out.add(Account.fromProto(proto));
            }
            return out;
        }

        public ServiceProviderProto.ServiceContext.Account toProto() {
            Account obj = this;
            ServiceProviderProto.ServiceContext.Account.Builder outBuilder = ServiceProviderProto.ServiceContext.Account.newBuilder();
            outBuilder.setAccountId(obj.getAccountId());
            return outBuilder.build();
        }

        public static List<ServiceProviderProto.ServiceContext.Account> toProtos(List<Account> objects) {
            ArrayList<ServiceProviderProto.ServiceContext.Account> out = new ArrayList<ServiceProviderProto.ServiceContext.Account>();
            if (objects != null) {
                for (Account obj : objects) {
                    out.add(obj != null ? obj.toProto() : null);
                }
            }
            return out;
        }

        public static class Builder {
            private String accountId = "";

            public Builder setAccountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public Account build() {
                return new Account(this.accountId);
            }
        }
    }
}

