/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1.internal;

import com.google.protobuf.Empty;
import com.vendasta.sso.v1.Config;
import com.vendasta.sso.v1.internal.CreateServiceProviderRequest;
import com.vendasta.sso.v1.internal.DeleteServiceProviderRequest;
import com.vendasta.sso.v1.internal.GetServiceProviderRequest;
import com.vendasta.sso.v1.internal.GetServiceProviderResponse;
import com.vendasta.sso.v1.internal.ServiceProviderAdminClientInterface;
import com.vendasta.sso.v1.internal.ServiceProviderAdminGRPCClient;
import com.vendasta.sso.v1.internal.ServiceProviderAdminHTTPClient;
import com.vendasta.sso.v1.internal.UpdateServiceProviderRequest;
import com.vendasta.vax.Environment;
import com.vendasta.vax.EnvironmentConfig;
import com.vendasta.vax.RequestOptions;
import com.vendasta.vax.SDKException;
import java.io.InputStream;

public class ServiceProviderAdminGeneratedClient
implements ServiceProviderAdminClientInterface {
    private ServiceProviderAdminClientInterface transport;

    public ServiceProviderAdminGeneratedClient(Environment environment) {
        this(environment, 10000.0f);
    }

    public ServiceProviderAdminGeneratedClient(Environment environment, Options options) {
        this.transport = this.getTransportClient(environment, options);
    }

    public ServiceProviderAdminGeneratedClient(Environment environment, float defaultTimeout) {
        Options opts = new Options.Builder().setDefaultTimeout(Float.valueOf(defaultTimeout)).build();
        this.transport = this.getTransportClient(environment, opts);
    }

    public ServiceProviderAdminGeneratedClient(Environment environment, InputStream serviceAccount, float defaultTimeout) {
        Options opts = new Options.Builder().setDefaultTimeout(Float.valueOf(defaultTimeout)).build();
        this.transport = this.getTransportClient(environment, serviceAccount, opts);
    }

    public ServiceProviderAdminGeneratedClient(Environment environment, InputStream serviceAccount, Options options) {
        this.transport = this.getTransportClient(environment, serviceAccount, options);
    }

    private ServiceProviderAdminClientInterface getTransportClient(Environment environment, Options options) {
        EnvironmentConfig config = Config.getEnvironmentConfig(environment);
        if (options.getUseHttp().booleanValue()) {
            return new ServiceProviderAdminHTTPClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            return new ServiceProviderAdminGRPCClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        catch (ClassNotFoundException e) {
            return new ServiceProviderAdminHTTPClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
    }

    private ServiceProviderAdminClientInterface getTransportClient(Environment environment, InputStream serviceAccount, Options options) {
        EnvironmentConfig config = Config.getEnvironmentConfig(environment);
        if (options.getUseHttp().booleanValue()) {
            return new ServiceProviderAdminHTTPClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            return new ServiceProviderAdminGRPCClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        catch (ClassNotFoundException e) {
            return new ServiceProviderAdminHTTPClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
    }

    @Override
    public Empty CreateServiceProvider(CreateServiceProviderRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.CreateServiceProvider(req, options);
    }

    @Override
    public GetServiceProviderResponse GetServiceProvider(GetServiceProviderRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.GetServiceProvider(req, options);
    }

    @Override
    public Empty UpdateServiceProvider(UpdateServiceProviderRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.UpdateServiceProvider(req, options);
    }

    @Override
    public Empty DeleteServiceProvider(DeleteServiceProviderRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.DeleteServiceProvider(req, options);
    }

    public static class Options {
        private Boolean useHttp = false;
        private float defaultTimeout = 10000.0f;

        Options(Builder builder) {
            if (builder.useHttp != null) {
                this.useHttp = builder.useHttp;
            }
            if (builder.defaultTimeout != null) {
                this.defaultTimeout = builder.defaultTimeout.floatValue();
            }
        }

        Boolean getUseHttp() {
            return this.useHttp;
        }

        Float getDefaultTimeout() {
            return Float.valueOf(this.defaultTimeout);
        }

        public static class Builder {
            private Boolean useHttp;
            private Float defaultTimeout;

            public static Builder newBuilder() {
                return new Builder();
            }

            public Builder useHttp() {
                this.useHttp = true;
                return this;
            }

            public Builder setDefaultTimeout(Float defaultTimeout) {
                this.defaultTimeout = defaultTimeout;
                return this;
            }

            public Options build() {
                return new Options(this);
            }
        }
    }
}

