/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1.internal;

import com.vendasta.sso.v1.generated.ServiceProviderAdminProto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ServiceProviderConfig {
    private final String serviceProviderId;
    private final String entryUrl;
    private final String sessionUrl;
    private final String primaryDomain;
    private final List<String> alternativeDomains;
    private final boolean ownedAndOperated;
    private final String logoutUrl;

    private ServiceProviderConfig(String serviceProviderId, String entryUrl, String sessionUrl, String primaryDomain, List<String> alternativeDomains, boolean ownedAndOperated, String logoutUrl) {
        this.serviceProviderId = serviceProviderId;
        this.entryUrl = entryUrl;
        this.sessionUrl = sessionUrl;
        this.primaryDomain = primaryDomain;
        this.alternativeDomains = alternativeDomains;
        this.ownedAndOperated = ownedAndOperated;
        this.logoutUrl = logoutUrl;
    }

    public String getServiceProviderId() {
        return this.serviceProviderId;
    }

    public String getEntryUrl() {
        return this.entryUrl;
    }

    public String getSessionUrl() {
        return this.sessionUrl;
    }

    public String getPrimaryDomain() {
        return this.primaryDomain;
    }

    public List<String> getAlternativeDomains() {
        return this.alternativeDomains;
    }

    public boolean getOwnedAndOperated() {
        return this.ownedAndOperated;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        String result = "ServiceProviderConfig\n";
        result = result + "-> serviceProviderId: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.serviceProviderId).split("\n"))}) + "\n";
        result = result + "-> entryUrl: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.entryUrl).split("\n"))}) + "\n";
        result = result + "-> sessionUrl: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.sessionUrl).split("\n"))}) + "\n";
        result = result + "-> primaryDomain: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.primaryDomain).split("\n"))}) + "\n";
        result = result + "-> alternativeDomains: (List<String>)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.alternativeDomains).split("\n"))}) + "\n";
        result = result + "-> ownedAndOperated: (boolean)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.ownedAndOperated).split("\n"))}) + "\n";
        result = result + "-> logoutUrl: (String)" + StringUtils.join((Object[])new Object[]{"\n  ", Arrays.asList(String.valueOf(this.logoutUrl).split("\n"))}) + "\n";
        return result;
    }

    public static ServiceProviderConfig fromProto(ServiceProviderAdminProto.ServiceProviderConfig proto) {
        ServiceProviderConfig out = null;
        if (proto != null) {
            Builder outBuilder = ServiceProviderConfig.newBuilder().setServiceProviderId(proto.getServiceProviderId()).setEntryUrl(proto.getEntryUrl()).setSessionUrl(proto.getSessionUrl()).setPrimaryDomain(proto.getPrimaryDomain()).setAlternativeDomains((List<String>)proto.getAlternativeDomainsList()).setOwnedAndOperated(proto.getOwnedAndOperated()).setLogoutUrl(proto.getLogoutUrl());
            out = outBuilder.build();
        }
        return out;
    }

    public static List<ServiceProviderConfig> fromProtos(List<ServiceProviderAdminProto.ServiceProviderConfig> protos) {
        ArrayList<ServiceProviderConfig> out = new ArrayList<ServiceProviderConfig>();
        for (ServiceProviderAdminProto.ServiceProviderConfig proto : protos) {
            out.add(ServiceProviderConfig.fromProto(proto));
        }
        return out;
    }

    public ServiceProviderAdminProto.ServiceProviderConfig toProto() {
        ServiceProviderConfig obj = this;
        ServiceProviderAdminProto.ServiceProviderConfig.Builder outBuilder = ServiceProviderAdminProto.ServiceProviderConfig.newBuilder();
        outBuilder.setServiceProviderId(obj.getServiceProviderId());
        outBuilder.setEntryUrl(obj.getEntryUrl());
        outBuilder.setSessionUrl(obj.getSessionUrl());
        outBuilder.setPrimaryDomain(obj.getPrimaryDomain());
        outBuilder.addAllAlternativeDomains(obj.getAlternativeDomains());
        outBuilder.setOwnedAndOperated(obj.getOwnedAndOperated());
        outBuilder.setLogoutUrl(obj.getLogoutUrl());
        return outBuilder.build();
    }

    public static List<ServiceProviderAdminProto.ServiceProviderConfig> toProtos(List<ServiceProviderConfig> objects) {
        ArrayList<ServiceProviderAdminProto.ServiceProviderConfig> out = new ArrayList<ServiceProviderAdminProto.ServiceProviderConfig>();
        if (objects != null) {
            for (ServiceProviderConfig obj : objects) {
                out.add(obj != null ? obj.toProto() : null);
            }
        }
        return out;
    }

    public static class Builder {
        private String serviceProviderId = "";
        private String entryUrl = "";
        private String sessionUrl = "";
        private String primaryDomain = "";
        private List<String> alternativeDomains = new ArrayList<String>();
        private boolean ownedAndOperated = false;
        private String logoutUrl = "";

        public Builder setServiceProviderId(String serviceProviderId) {
            this.serviceProviderId = serviceProviderId;
            return this;
        }

        public Builder setEntryUrl(String entryUrl) {
            this.entryUrl = entryUrl;
            return this;
        }

        public Builder setSessionUrl(String sessionUrl) {
            this.sessionUrl = sessionUrl;
            return this;
        }

        public Builder setPrimaryDomain(String primaryDomain) {
            this.primaryDomain = primaryDomain;
            return this;
        }

        public Builder setAlternativeDomains(List<String> alternativeDomains) {
            this.alternativeDomains = alternativeDomains;
            return this;
        }

        public Builder setOwnedAndOperated(boolean ownedAndOperated) {
            this.ownedAndOperated = ownedAndOperated;
            return this;
        }

        public Builder setLogoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public ServiceProviderConfig build() {
            return new ServiceProviderConfig(this.serviceProviderId, this.entryUrl, this.sessionUrl, this.primaryDomain, this.alternativeDomains, this.ownedAndOperated, this.logoutUrl);
        }
    }
}

