/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.sso.v1.internal;

import com.vendasta.sso.v1.Config;
import com.vendasta.sso.v1.internal.GetLogoutURLRequest;
import com.vendasta.sso.v1.internal.GetLogoutURLResponse;
import com.vendasta.sso.v1.internal.GetSessionTransferURLRequest;
import com.vendasta.sso.v1.internal.GetSessionTransferURLResponse;
import com.vendasta.sso.v1.internal.ServiceProviderClientInterface;
import com.vendasta.sso.v1.internal.ServiceProviderGRPCClient;
import com.vendasta.sso.v1.internal.ServiceProviderHTTPClient;
import com.vendasta.vax.Environment;
import com.vendasta.vax.EnvironmentConfig;
import com.vendasta.vax.RequestOptions;
import com.vendasta.vax.SDKException;
import java.io.InputStream;

public class ServiceProviderGeneratedClient
implements ServiceProviderClientInterface {
    private ServiceProviderClientInterface transport;

    public ServiceProviderGeneratedClient(Environment environment) {
        this(environment, 10000.0f);
    }

    public ServiceProviderGeneratedClient(Environment environment, Options options) {
        this.transport = this.getTransportClient(environment, options);
    }

    public ServiceProviderGeneratedClient(Environment environment, float defaultTimeout) {
        Options opts = new Options.Builder().setDefaultTimeout(Float.valueOf(defaultTimeout)).build();
        this.transport = this.getTransportClient(environment, opts);
    }

    public ServiceProviderGeneratedClient(Environment environment, InputStream serviceAccount, float defaultTimeout) {
        Options opts = new Options.Builder().setDefaultTimeout(Float.valueOf(defaultTimeout)).build();
        this.transport = this.getTransportClient(environment, serviceAccount, opts);
    }

    public ServiceProviderGeneratedClient(Environment environment, InputStream serviceAccount, Options options) {
        this.transport = this.getTransportClient(environment, serviceAccount, options);
    }

    private ServiceProviderClientInterface getTransportClient(Environment environment, Options options) {
        EnvironmentConfig config = Config.getEnvironmentConfig(environment);
        if (options.getUseHttp().booleanValue()) {
            return new ServiceProviderHTTPClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            return new ServiceProviderGRPCClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        catch (ClassNotFoundException e) {
            return new ServiceProviderHTTPClient(config.getHost(), config.getScope(), config.isSecure(), options.getDefaultTimeout().floatValue());
        }
    }

    private ServiceProviderClientInterface getTransportClient(Environment environment, InputStream serviceAccount, Options options) {
        EnvironmentConfig config = Config.getEnvironmentConfig(environment);
        if (options.getUseHttp().booleanValue()) {
            return new ServiceProviderHTTPClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            return new ServiceProviderGRPCClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
        catch (ClassNotFoundException e) {
            return new ServiceProviderHTTPClient(config.getHost(), config.getScope(), serviceAccount, config.isSecure(), options.getDefaultTimeout().floatValue());
        }
    }

    @Override
    public GetSessionTransferURLResponse GetSessionTransferURL(GetSessionTransferURLRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.GetSessionTransferURL(req, options);
    }

    @Override
    public GetLogoutURLResponse GetLogoutURL(GetLogoutURLRequest req, RequestOptions.Builder options) throws SDKException {
        return this.transport.GetLogoutURL(req, options);
    }

    public static class Options {
        private Boolean useHttp = false;
        private float defaultTimeout = 10000.0f;

        Options(Builder builder) {
            if (builder.useHttp != null) {
                this.useHttp = builder.useHttp;
            }
            if (builder.defaultTimeout != null) {
                this.defaultTimeout = builder.defaultTimeout.floatValue();
            }
        }

        Boolean getUseHttp() {
            return this.useHttp;
        }

        Float getDefaultTimeout() {
            return Float.valueOf(this.defaultTimeout);
        }

        public static class Builder {
            private Boolean useHttp;
            private Float defaultTimeout;

            public static Builder newBuilder() {
                return new Builder();
            }

            public Builder useHttp() {
                this.useHttp = true;
                return this;
            }

            public Builder setDefaultTimeout(Float defaultTimeout) {
                this.defaultTimeout = defaultTimeout;
                return this;
            }

            public Options build() {
                return new Options(this);
            }
        }
    }
}

