/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.adapters.impl;

import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.model.util.JSON;
import com.veracode.apiwrapper.rest.ApiEndpoint;
import com.veracode.apiwrapper.utils.UserAgent;
import com.veracode.http.Credentials;
import com.veracode.http.util.ExceptionUtil;
import com.veracode.http.util.HmacAuthHeaderGenerator;
import com.veracode.util.lang.StringUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public abstract class BaseAdapter {
    private static final String HTTPS = "https";
    private static final String CONTENT_TYPE = "application/json";
    private static final String RESPONSE_MEDIA_TYPE_HAL_JSON = "application/hal+json";
    private static final String RESPONSE_MEDIA_TYPE_JSON = "application/json";
    private static final Set<String> VALID_RESPONSE_MEDIA_TYPES;
    private static final String REST_API_HOST_ENV_VAR = "VERACODE_REST_API_HOST";
    private static final String REST_API_PORT_ENV_VAR = "VERACODE_REST_API_PORT";
    private static final String REST_API_HOST;
    private static final int REST_API_PORT;
    private static final int REST_TIMEOUT_SECONDS = 30;
    private final JSON json = new JSON();
    private final Credentials creds;
    private final Proxy proxy;
    private final UserAgent userAgent;

    protected BaseAdapter(Credentials creds, Proxy proxy) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot create an adapter without credentials.");
        }
        this.creds = creds;
        this.proxy = null == proxy ? Proxy.NO_PROXY : proxy;
        this.userAgent = new UserAgent();
    }

    protected BaseAdapter(Credentials creds, Proxy proxy, UserAgent userAgent) {
        if (null == creds) {
            throw new IllegalArgumentException("Cannot create an adapter without credentials.");
        }
        this.creds = creds;
        this.proxy = null == proxy ? Proxy.NO_PROXY : proxy;
        this.userAgent = null == userAgent ? new UserAgent() : userAgent;
    }

    protected Credentials getCredentials() {
        return this.creds;
    }

    protected Proxy getProxy() {
        return this.proxy;
    }

    protected UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected String getAuthorizationHeader(URL url, String httpMethod) {
        String header = "";
        try {
            header = HmacAuthHeaderGenerator.getVeracodeAuthorizationHeader(this.creds.getId(), this.creds.getKey(), url, httpMethod);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate HMAC header due to invalid API credentials", e);
        }
        return header;
    }

    protected JSON getJSON() {
        return this.json;
    }

    protected String getContentType() {
        return "application/json";
    }

    protected Set<String> getResponseMediaType() {
        return VALID_RESPONSE_MEDIA_TYPES;
    }

    protected boolean isValidResponseMediaType(String mediaType) {
        return this.getResponseMediaType().stream().anyMatch(mediaType::equalsIgnoreCase);
    }

    /*
     * Exception decompiling
     */
    protected final String getRequest(ApiEndpoint endpoint, Map<String, String> arguments, Map<String, String> query) throws ApiException, InvocationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected final String updateRequest(ApiEndpoint endpoint, Map<String, String> arguments, String body, Map<String, String> query) throws ApiException, InvocationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL constructUrl(ApiEndpoint endpoint, Map<String, String> arguments, Map<String, String> query) {
        if (null == endpoint) {
            throw new IllegalArgumentException("API endpoint to be invoked is missing.");
        }
        String restApiHostName = REST_API_HOST.isEmpty() ? this.creds.getRegion().getRestApiHost() : REST_API_HOST;
        URL apiUrl = null;
        try {
            apiUrl = REST_API_PORT != 443 ? new URL(String.format("%s://%s:%d/%s", HTTPS, restApiHostName, Math.min(65535, REST_API_PORT), endpoint.generateUri(arguments, query))) : new URL(String.format("%s://%s/%s", HTTPS, restApiHostName, endpoint.generateUri(arguments, query)));
            URI uri = new URI(apiUrl.getProtocol(), apiUrl.getUserInfo(), apiUrl.getHost(), apiUrl.getPort(), apiUrl.getPath(), apiUrl.getQuery(), apiUrl.getRef());
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Cannot construct a well formatted URL with the given query.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApiException createApiException(HttpsURLConnection conn, IOException e) {
        try (InputStream responseErrorStream = conn.getErrorStream();){
            String response = BaseAdapter.readResponse(responseErrorStream);
            ApiException apiEx = null;
            String mediaType = BaseAdapter.getMediaType(conn.getContentType());
            apiEx = StringUtility.isNullOrEmpty(response) || this.isValidResponseMediaType(mediaType) ? ExceptionUtil.createException(conn.getResponseCode(), response, e) : ExceptionUtil.createInvalidMediaTypeException(conn.getResponseCode(), this.getResponseMediaType(), mediaType, e);
            ApiException apiException = apiEx;
            return apiException;
        }
        catch (IOException e1) {
            throw new RuntimeException("Unable to read the error stream of the request.", e1);
        }
    }

    private static String readResponse(InputStream responseInputStream) throws IOException {
        if (null == responseInputStream) {
            return "";
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] responseBytes = new byte[16384];
        int x = 0;
        while ((x = responseInputStream.read(responseBytes, 0, responseBytes.length)) != -1) {
            outputStream.write(responseBytes, 0, x);
        }
        outputStream.flush();
        return outputStream.toString();
    }

    private static String getMediaType(String contentType) {
        return StringUtility.isNullOrEmpty(contentType) ? "" : contentType.split(";")[0];
    }

    static {
        int port;
        VALID_RESPONSE_MEDIA_TYPES = new HashSet<String>(Arrays.asList(RESPONSE_MEDIA_TYPE_HAL_JSON, "application/json"));
        String restApiHost = System.getenv(REST_API_HOST_ENV_VAR);
        REST_API_HOST = restApiHost == null || restApiHost.isEmpty() ? "" : restApiHost;
        String restApiPort = System.getenv(REST_API_PORT_ENV_VAR);
        try {
            port = Integer.parseUnsignedInt(restApiPort);
        }
        catch (NumberFormatException nfe) {
            port = 443;
        }
        REST_API_PORT = port;
    }

    private static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

