/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.application.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Reference to the latest scan of this application.")
public class ApplicationScan {
    @SerializedName(value="internal_status")
    private String internalStatus = null;
    @SerializedName(value="modified_date")
    private OffsetDateTime modifiedDate = null;
    @SerializedName(value="scan_type")
    private ScanTypeEnum scanType = null;
    @SerializedName(value="scan_url")
    private String scanUrl = null;
    @SerializedName(value="status")
    private StatusEnum status = null;

    public ApplicationScan internalStatus(String internalStatus) {
        this.internalStatus = internalStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public String getInternalStatus() {
        return this.internalStatus;
    }

    public void setInternalStatus(String internalStatus) {
        this.internalStatus = internalStatus;
    }

    @ApiModelProperty(value="The date when the scan results were published. The date/time format is per RFC3339 and ISO-8601, and the timezone is UTC. Example: 2019-04-12T23:20:50.52Z.")
    public OffsetDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    @ApiModelProperty(value="Type of scan in which this finding was discovered.")
    public ScanTypeEnum getScanType() {
        return this.scanType;
    }

    @ApiModelProperty(value="Unique path to the latest scan.")
    public String getScanUrl() {
        return this.scanUrl;
    }

    public ApplicationScan status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Scan status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationScan applicationScan = (ApplicationScan)o;
        return Objects.equals(this.internalStatus, applicationScan.internalStatus) && Objects.equals(this.modifiedDate, applicationScan.modifiedDate) && Objects.equals((Object)this.scanType, (Object)applicationScan.scanType) && Objects.equals(this.scanUrl, applicationScan.scanUrl) && Objects.equals((Object)this.status, (Object)applicationScan.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.internalStatus, this.modifiedDate, this.scanType, this.scanUrl, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationScan {\n");
        sb.append("    internalStatus: ").append(this.toIndentedString(this.internalStatus)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    scanType: ").append(this.toIndentedString((Object)this.scanType)).append("\n");
        sb.append("    scanUrl: ").append(this.toIndentedString(this.scanUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        CREATED("CREATED"),
        UNPUBLISHED("UNPUBLISHED"),
        DELETED("DELETED"),
        PARTIAL_PUBLISH("PARTIAL_PUBLISH"),
        PARTIAL_UNPUBLISH("PARTIAL_UNPUBLISH"),
        INCOMPLETE("INCOMPLETE"),
        SCAN_SUBMITTED("SCAN_SUBMITTED"),
        IN_QUEUE("IN_QUEUE"),
        STOPPING("STOPPING"),
        PAUSING("PAUSING"),
        IN_PROGRESS("IN_PROGRESS"),
        ANALYSIS_ERRORS("ANALYSIS_ERRORS"),
        SCAN_CANCELED("SCAN_CANCELED"),
        INTERNAL_REVIEW("INTERNAL_REVIEW"),
        VERIFYING_RESULTS("VERIFYING_RESULTS"),
        SUBMITTED_FOR_NTO_PRE_SCAN("SUBMITTED_FOR_NTO_PRE_SCAN"),
        SUBMITTED_FOR_DYNAMIC_PRE_SCAN("SUBMITTED_FOR_DYNAMIC_PRE_SCAN"),
        PRE_SCAN_FAILED("PRE_SCAN_FAILED"),
        READY_TO_SUBMIT("READY_TO_SUBMIT"),
        NTO_PENDING_SUBMISSION("NTO_PENDING_SUBMISSION"),
        PRE_SCAN_COMPLETE("PRE_SCAN_COMPLETE"),
        MODULE_SELECTION_REQUIRED("MODULE_SELECTION_REQUIRED"),
        PENDING_VENDOR_ACCEPTANCE("PENDING_VENDOR_ACCEPTANCE"),
        SHOW_OSRDB("SHOW_OSRDB"),
        PUBLISHED("PUBLISHED"),
        PUBLISHED_TO_VENDOR("PUBLISHED_TO_VENDOR"),
        PUBLISHED_TO_ENTERPRISE("PUBLISHED_TO_ENTERPRISE"),
        PENDING_ACCOUNT_APPROVAL("PENDING_ACCOUNT_APPROVAL"),
        PENDING_LEGAL_AGREEMENT("PENDING_LEGAL_AGREEMENT"),
        SCAN_IN_PROGRESS("SCAN_IN_PROGRESS"),
        SCAN_IN_PROGRESS_PARTIAL_RESULTS_READY("SCAN_IN_PROGRESS_PARTIAL_RESULTS_READY"),
        PROMOTE_IN_PROGRESS("PROMOTE_IN_PROGRESS"),
        PRE_SCAN_CANCELED("PRE_SCAN_CANCELED"),
        NTO_PRE_SCAN_CANCELED("NTO_PRE_SCAN_CANCELED"),
        SCAN_HELD_APPROVAL("SCAN_HELD_APPROVAL"),
        SCAN_HELD_LOGIN_INSTRUCTIONS("SCAN_HELD_LOGIN_INSTRUCTIONS"),
        SCAN_HELD_LOGIN("SCAN_HELD_LOGIN"),
        SCAN_HELD_INSTRUCTIONS("SCAN_HELD_INSTRUCTIONS"),
        SCAN_HELD_HOLDS_FINISHED("SCAN_HELD_HOLDS_FINISHED"),
        SCAN_REQUESTED("SCAN_REQUESTED"),
        TIMEFRAMEPENDING_ID("TIMEFRAMEPENDING_ID"),
        PAUSED_ID("PAUSED_ID"),
        STATIC_VALIDATING_UPLOAD("STATIC_VALIDATING_UPLOAD"),
        PUBLISHED_TO_ENTERPRISEINT("PUBLISHED_TO_ENTERPRISEINT");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScanTypeEnum {
        STATIC("STATIC"),
        DYNAMIC("DYNAMIC"),
        MANUAL("MANUAL"),
        SCA("SCA");

        private String value;

        private ScanTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScanTypeEnum fromValue(String text) {
            for (ScanTypeEnum b : ScanTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ScanTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ScanTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ScanTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScanTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

