/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisOccurrenceStatus;
import com.veracode.apiwrapper.dynamicanalysis.model.api.Link;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Representation of an analysis occurrence. An analysis occurence is an instance of a Dynamic Analysis that is running or has run")
public class AnalysisOccurrence {
    @SerializedName(value="actual_end_date")
    private String actualEndDate = null;
    @SerializedName(value="actual_start_date")
    private String actualStartDate = null;
    @SerializedName(value="all_scans_passed_verification")
    private Boolean allScansPassedVerification = null;
    @SerializedName(value="analysis_id")
    private String analysisId = null;
    @SerializedName(value="analysis_occurrence_id")
    private String analysisOccurrenceId = null;
    @SerializedName(value="count_of_failed_verifications")
    private Long countOfFailedVerifications = null;
    @SerializedName(value="duration")
    private String duration = null;
    @SerializedName(value="end_date")
    private String endDate = null;
    @SerializedName(value="percent_scanned")
    private Integer percentScanned = null;
    @SerializedName(value="start_date")
    private String startDate = null;
    @SerializedName(value="status")
    private AnalysisOccurrenceStatus status = null;
    @SerializedName(value="verification_only")
    private Boolean verificationOnly = null;
    @SerializedName(value="created_on")
    private String createdOn = null;
    @SerializedName(value="last_modified_on")
    private String lastModifiedOn = null;
    @SerializedName(value="links")
    private List<Link> links = null;

    public AnalysisOccurrence actualEndDate(String actualEndDate) {
        this.actualEndDate = actualEndDate;
        return this;
    }

    @ApiModelProperty(value="Actual End Date Time")
    public String getActualEndDate() {
        return this.actualEndDate;
    }

    public void setActualEndDate(String actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public AnalysisOccurrence actualStartDate(String actualStartDate) {
        this.actualStartDate = actualStartDate;
        return this;
    }

    @ApiModelProperty(value="Actual Start Date Time")
    public String getActualStartDate() {
        return this.actualStartDate;
    }

    public void setActualStartDate(String actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public AnalysisOccurrence allScansPassedVerification(Boolean allScansPassedVerification) {
        this.allScansPassedVerification = allScansPassedVerification;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isAllScansPassedVerification() {
        return this.allScansPassedVerification;
    }

    public void setAllScansPassedVerification(Boolean allScansPassedVerification) {
        this.allScansPassedVerification = allScansPassedVerification;
    }

    public AnalysisOccurrence analysisId(String analysisId) {
        this.analysisId = analysisId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the analysis this occurrence is based on. Cannot be null or empty")
    public String getAnalysisId() {
        return this.analysisId;
    }

    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }

    public AnalysisOccurrence analysisOccurrenceId(String analysisOccurrenceId) {
        this.analysisOccurrenceId = analysisOccurrenceId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier and locator. Cannot be null or empty")
    public String getAnalysisOccurrenceId() {
        return this.analysisOccurrenceId;
    }

    public void setAnalysisOccurrenceId(String analysisOccurrenceId) {
        this.analysisOccurrenceId = analysisOccurrenceId;
    }

    public AnalysisOccurrence countOfFailedVerifications(Long countOfFailedVerifications) {
        this.countOfFailedVerifications = countOfFailedVerifications;
        return this;
    }

    @ApiModelProperty(value="Number of scan occurrences which has failed verifications")
    public Long getCountOfFailedVerifications() {
        return this.countOfFailedVerifications;
    }

    public void setCountOfFailedVerifications(Long countOfFailedVerifications) {
        this.countOfFailedVerifications = countOfFailedVerifications;
    }

    public AnalysisOccurrence duration(String duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="Duration")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public AnalysisOccurrence endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="Scheduled End Date Time")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public AnalysisOccurrence percentScanned(Integer percentScanned) {
        this.percentScanned = percentScanned;
        return this;
    }

    @ApiModelProperty(value="Percentage of scans done")
    public Integer getPercentScanned() {
        return this.percentScanned;
    }

    public void setPercentScanned(Integer percentScanned) {
        this.percentScanned = percentScanned;
    }

    public AnalysisOccurrence startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Scheduled Start Date Time")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public AnalysisOccurrence status(AnalysisOccurrenceStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the analysis occurrence. Cannot null or empty")
    public AnalysisOccurrenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(AnalysisOccurrenceStatus status) {
        this.status = status;
    }

    public AnalysisOccurrence verificationOnly(Boolean verificationOnly) {
        this.verificationOnly = verificationOnly;
        return this;
    }

    @ApiModelProperty(example="false", value="true if this analysis occurrence is for verification only otherwise false")
    public Boolean isVerificationOnly() {
        return this.verificationOnly;
    }

    public void setVerificationOnly(Boolean verificationOnly) {
        this.verificationOnly = verificationOnly;
    }

    public AnalysisOccurrence createdOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @ApiModelProperty(value="UTC date time representation of the time the record was created")
    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public AnalysisOccurrence lastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
        return this;
    }

    @ApiModelProperty(value="UTC date time representation of the time the record was last modified")
    public String getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public AnalysisOccurrence links(List<Link> links) {
        this.links = links;
        return this;
    }

    public AnalysisOccurrence addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisOccurrence analysisOccurrence = (AnalysisOccurrence)o;
        return Objects.equals(this.actualEndDate, analysisOccurrence.actualEndDate) && Objects.equals(this.actualStartDate, analysisOccurrence.actualStartDate) && Objects.equals(this.allScansPassedVerification, analysisOccurrence.allScansPassedVerification) && Objects.equals(this.analysisId, analysisOccurrence.analysisId) && Objects.equals(this.analysisOccurrenceId, analysisOccurrence.analysisOccurrenceId) && Objects.equals(this.countOfFailedVerifications, analysisOccurrence.countOfFailedVerifications) && Objects.equals(this.duration, analysisOccurrence.duration) && Objects.equals(this.endDate, analysisOccurrence.endDate) && Objects.equals(this.percentScanned, analysisOccurrence.percentScanned) && Objects.equals(this.startDate, analysisOccurrence.startDate) && Objects.equals(this.status, analysisOccurrence.status) && Objects.equals(this.verificationOnly, analysisOccurrence.verificationOnly) && Objects.equals(this.createdOn, analysisOccurrence.createdOn) && Objects.equals(this.lastModifiedOn, analysisOccurrence.lastModifiedOn) && Objects.equals(this.links, analysisOccurrence.links);
    }

    public int hashCode() {
        return Objects.hash(this.actualEndDate, this.actualStartDate, this.allScansPassedVerification, this.analysisId, this.analysisOccurrenceId, this.countOfFailedVerifications, this.duration, this.endDate, this.percentScanned, this.startDate, this.status, this.verificationOnly, this.createdOn, this.lastModifiedOn, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalysisOccurrence {\n");
        sb.append("    actualEndDate: ").append(this.toIndentedString(this.actualEndDate)).append("\n");
        sb.append("    actualStartDate: ").append(this.toIndentedString(this.actualStartDate)).append("\n");
        sb.append("    allScansPassedVerification: ").append(this.toIndentedString(this.allScansPassedVerification)).append("\n");
        sb.append("    analysisId: ").append(this.toIndentedString(this.analysisId)).append("\n");
        sb.append("    analysisOccurrenceId: ").append(this.toIndentedString(this.analysisOccurrenceId)).append("\n");
        sb.append("    countOfFailedVerifications: ").append(this.toIndentedString(this.countOfFailedVerifications)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    percentScanned: ").append(this.toIndentedString(this.percentScanned)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    verificationOnly: ").append(this.toIndentedString(this.verificationOnly)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    lastModifiedOn: ").append(this.toIndentedString(this.lastModifiedOn)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

