/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.dynamicanalysis.model.api.OrgInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanRequest;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanSchedule;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanSetting;
import com.veracode.apiwrapper.dynamicanalysis.model.api.VisibilitySetup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Representation of a Dynamic Analysis request. A Dynamic Analysis or Analysis can contain one or multiple scans - each for a unique application configuration - that are run on the same schedule and share a common set of configurations. Can be used for creating or updating")
public class AnalysisRequest {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="org_info")
    private OrgInformation orgInfo = null;
    @SerializedName(value="scan_setting")
    private ScanSetting scanSetting = null;
    @SerializedName(value="scans")
    private List<ScanRequest> scans = null;
    @SerializedName(value="schedule")
    private ScanSchedule schedule = null;
    @SerializedName(value="special_instructions")
    private String specialInstructions = null;
    @SerializedName(value="visibility")
    private VisibilitySetup visibility = null;

    public AnalysisRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the analysis. Must be unique within the account and between 6 and 256 chars (inclusive)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AnalysisRequest orgInfo(OrgInformation orgInfo) {
        this.orgInfo = orgInfo;
        return this;
    }

    @ApiModelProperty(value="Organization information")
    public OrgInformation getOrgInfo() {
        return this.orgInfo;
    }

    public void setOrgInfo(OrgInformation orgInfo) {
        this.orgInfo = orgInfo;
    }

    public AnalysisRequest scanSetting(ScanSetting scanSetting) {
        this.scanSetting = scanSetting;
        return this;
    }

    @ApiModelProperty(value="Analysis level scan setting that applies to all scans in this analysis")
    public ScanSetting getScanSetting() {
        return this.scanSetting;
    }

    public void setScanSetting(ScanSetting scanSetting) {
        this.scanSetting = scanSetting;
    }

    public AnalysisRequest scans(List<ScanRequest> scans) {
        this.scans = scans;
        return this;
    }

    public AnalysisRequest addScansItem(ScanRequest scansItem) {
        if (this.scans == null) {
            this.scans = new ArrayList<ScanRequest>();
        }
        this.scans.add(scansItem);
        return this;
    }

    @ApiModelProperty(value="List of scans included in the analysis. Can be present when creating the analysis. May not be present in serialized form and replaced with resource links")
    public List<ScanRequest> getScans() {
        return this.scans;
    }

    public void setScans(List<ScanRequest> scans) {
        this.scans = scans;
    }

    public AnalysisRequest schedule(ScanSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="The scan schedule")
    public ScanSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ScanSchedule schedule) {
        this.schedule = schedule;
    }

    public AnalysisRequest specialInstructions(String specialInstructions) {
        this.specialInstructions = specialInstructions;
        return this;
    }

    @ApiModelProperty(value="Special instructions related to the analysis. Can be null. Can hold up scan if specified.")
    public String getSpecialInstructions() {
        return this.specialInstructions;
    }

    public void setSpecialInstructions(String specialInstructions) {
        this.specialInstructions = specialInstructions;
    }

    public AnalysisRequest visibility(VisibilitySetup visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(value="Visibility setup")
    public VisibilitySetup getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilitySetup visibility) {
        this.visibility = visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisRequest analysisRequest = (AnalysisRequest)o;
        return Objects.equals(this.name, analysisRequest.name) && Objects.equals(this.orgInfo, analysisRequest.orgInfo) && Objects.equals(this.scanSetting, analysisRequest.scanSetting) && Objects.equals(this.scans, analysisRequest.scans) && Objects.equals(this.schedule, analysisRequest.schedule) && Objects.equals(this.specialInstructions, analysisRequest.specialInstructions) && Objects.equals(this.visibility, analysisRequest.visibility);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.orgInfo, this.scanSetting, this.scans, this.schedule, this.specialInstructions, this.visibility);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalysisRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orgInfo: ").append(this.toIndentedString(this.orgInfo)).append("\n");
        sb.append("    scanSetting: ").append(this.toIndentedString(this.scanSetting)).append("\n");
        sb.append("    scans: ").append(this.toIndentedString(this.scans)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    specialInstructions: ").append(this.toIndentedString(this.specialInstructions)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

