/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents additional information for an application")
public class ApplicationInformation {
    @SerializedName(value="launch_date")
    private String launchDate = null;
    @SerializedName(value="lifecycle_stage")
    private LifecycleStageEnum lifecycleStage = null;
    @SerializedName(value="tags")
    private String tags = null;

    public ApplicationInformation launchDate(String launchDate) {
        this.launchDate = launchDate;
        return this;
    }

    @ApiModelProperty(value="The date for launch. Must be in ISO-8601 format e.g. 2016-12-03")
    public String getLaunchDate() {
        return this.launchDate;
    }

    public void setLaunchDate(String launchDate) {
        this.launchDate = launchDate;
    }

    public ApplicationInformation lifecycleStage(LifecycleStageEnum lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
        return this;
    }

    @ApiModelProperty(value="Lifecycle stage")
    public LifecycleStageEnum getLifecycleStage() {
        return this.lifecycleStage;
    }

    public void setLifecycleStage(LifecycleStageEnum lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
    }

    public ApplicationInformation tags(String tags) {
        this.tags = tags;
        return this;
    }

    @ApiModelProperty(value="Comma separated tags. Combined length must be less than 512 chars")
    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationInformation applicationInformation = (ApplicationInformation)o;
        return Objects.equals(this.launchDate, applicationInformation.launchDate) && Objects.equals((Object)this.lifecycleStage, (Object)applicationInformation.lifecycleStage) && Objects.equals(this.tags, applicationInformation.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.launchDate, this.lifecycleStage, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationInformation {\n");
        sb.append("    launchDate: ").append(this.toIndentedString(this.launchDate)).append("\n");
        sb.append("    lifecycleStage: ").append(this.toIndentedString((Object)this.lifecycleStage)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LifecycleStageEnum {
        NOT_SPECIFIED("NOT_SPECIFIED"),
        IN_DEVELOPMENT("IN_DEVELOPMENT"),
        INTERNAL_ALPHA("INTERNAL_ALPHA"),
        EXTERNAL_BETA("EXTERNAL_BETA"),
        DEPLOYED("DEPLOYED"),
        MAINTENANCE("MAINTENANCE"),
        NOT_DISCLOSED("NOT_DISCLOSED");

        private String value;

        private LifecycleStageEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LifecycleStageEnum fromValue(String text) {
            for (LifecycleStageEnum b : LifecycleStageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LifecycleStageEnum> {
            @Override
            public void write(JsonWriter jsonWriter, LifecycleStageEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public LifecycleStageEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LifecycleStageEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

