/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ApplicationInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ContactInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.OrgInformation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Representation of an application request. An application is an abstraction of a software component or components that can be the subject of a dynamic analysis if it has an interface exposed that supports access over the HTTP or HTTPS protocol.")
public class ApplicationRequest {
    @SerializedName(value="application_info")
    private ApplicationInformation applicationInfo = null;
    @SerializedName(value="contact_info")
    private ContactInformation contactInfo = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="org_info")
    private OrgInformation orgInfo = null;

    public ApplicationRequest applicationInfo(ApplicationInformation applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="Application information")
    public ApplicationInformation getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInformation applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public ApplicationRequest contactInfo(ContactInformation contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    @ApiModelProperty(value="Contact information for the application")
    public ContactInformation getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(ContactInformation contactInfo) {
        this.contactInfo = contactInfo;
    }

    public ApplicationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the application. If not specified defaults to the url of the default configuration")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationRequest orgInfo(OrgInformation orgInfo) {
        this.orgInfo = orgInfo;
        return this;
    }

    @ApiModelProperty(value="Organization information")
    public OrgInformation getOrgInfo() {
        return this.orgInfo;
    }

    public void setOrgInfo(OrgInformation orgInfo) {
        this.orgInfo = orgInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRequest applicationRequest = (ApplicationRequest)o;
        return Objects.equals(this.applicationInfo, applicationRequest.applicationInfo) && Objects.equals(this.contactInfo, applicationRequest.contactInfo) && Objects.equals(this.name, applicationRequest.name) && Objects.equals(this.orgInfo, applicationRequest.orgInfo);
    }

    public int hashCode() {
        return Objects.hash(this.applicationInfo, this.contactInfo, this.name, this.orgInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationRequest {\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    contactInfo: ").append(this.toIndentedString(this.contactInfo)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orgInfo: ").append(this.toIndentedString(this.orgInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

