/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AuthenticationConfiguration;
import com.veracode.apiwrapper.dynamicanalysis.model.api.CrawlConfiguration;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanSetting;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanURL;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Representation of an scan configuration request. Each application can have a number of configurations of which one can be default. The configurations are reusable set of application scan configurations. Configurations can be copied from another. Not all properties of a configuration need to be defined. If not defined, it is copied from the source configuration")
public class ScanConfigurationRequest {
    @SerializedName(value="allowed_hosts")
    private List<ScanURL> allowedHosts = null;
    @SerializedName(value="auth_configuration")
    private AuthenticationConfiguration authConfiguration = null;
    @SerializedName(value="crawl_configuration")
    private CrawlConfiguration crawlConfiguration = null;
    @SerializedName(value="scan_setting")
    private ScanSetting scanSetting = null;
    @SerializedName(value="target_url")
    private ScanURL targetUrl = null;

    public ScanConfigurationRequest allowedHosts(List<ScanURL> allowedHosts) {
        this.allowedHosts = allowedHosts;
        return this;
    }

    public ScanConfigurationRequest addAllowedHostsItem(ScanURL allowedHostsItem) {
        if (this.allowedHosts == null) {
            this.allowedHosts = new ArrayList<ScanURL>();
        }
        this.allowedHosts.add(allowedHostsItem);
        return this;
    }

    @ApiModelProperty(value="Additional allowed hosts for the scan with rules")
    public List<ScanURL> getAllowedHosts() {
        return this.allowedHosts;
    }

    public void setAllowedHosts(List<ScanURL> allowedHosts) {
        this.allowedHosts = allowedHosts;
    }

    public ScanConfigurationRequest authConfiguration(AuthenticationConfiguration authConfiguration) {
        this.authConfiguration = authConfiguration;
        return this;
    }

    @ApiModelProperty(value="Authentication configuration for the scan")
    public AuthenticationConfiguration getAuthConfiguration() {
        return this.authConfiguration;
    }

    public void setAuthConfiguration(AuthenticationConfiguration authConfiguration) {
        this.authConfiguration = authConfiguration;
    }

    public ScanConfigurationRequest crawlConfiguration(CrawlConfiguration crawlConfiguration) {
        this.crawlConfiguration = crawlConfiguration;
        return this;
    }

    @ApiModelProperty(value="Crawl configuration for the scan")
    public CrawlConfiguration getCrawlConfiguration() {
        return this.crawlConfiguration;
    }

    public void setCrawlConfiguration(CrawlConfiguration crawlConfiguration) {
        this.crawlConfiguration = crawlConfiguration;
    }

    public ScanConfigurationRequest scanSetting(ScanSetting scanSetting) {
        this.scanSetting = scanSetting;
        return this;
    }

    @ApiModelProperty(value="Scan setting. Not mandatory. If present, not everything needs to be specified.")
    public ScanSetting getScanSetting() {
        return this.scanSetting;
    }

    public void setScanSetting(ScanSetting scanSetting) {
        this.scanSetting = scanSetting;
    }

    public ScanConfigurationRequest targetUrl(ScanURL targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    @ApiModelProperty(value="Target URL for the scan with rules")
    public ScanURL getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(ScanURL targetUrl) {
        this.targetUrl = targetUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanConfigurationRequest scanConfigurationRequest = (ScanConfigurationRequest)o;
        return Objects.equals(this.allowedHosts, scanConfigurationRequest.allowedHosts) && Objects.equals(this.authConfiguration, scanConfigurationRequest.authConfiguration) && Objects.equals(this.crawlConfiguration, scanConfigurationRequest.crawlConfiguration) && Objects.equals(this.scanSetting, scanConfigurationRequest.scanSetting) && Objects.equals(this.targetUrl, scanConfigurationRequest.targetUrl);
    }

    public int hashCode() {
        return Objects.hash(this.allowedHosts, this.authConfiguration, this.crawlConfiguration, this.scanSetting, this.targetUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanConfigurationRequest {\n");
        sb.append("    allowedHosts: ").append(this.toIndentedString(this.allowedHosts)).append("\n");
        sb.append("    authConfiguration: ").append(this.toIndentedString(this.authConfiguration)).append("\n");
        sb.append("    crawlConfiguration: ").append(this.toIndentedString(this.crawlConfiguration)).append("\n");
        sb.append("    scanSetting: ").append(this.toIndentedString(this.scanSetting)).append("\n");
        sb.append("    targetUrl: ").append(this.toIndentedString(this.targetUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

