/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Describes how long scans should run")
public class ScanDuration {
    @SerializedName(value="length")
    private Integer length = null;
    @SerializedName(value="unit")
    private UnitEnum unit = null;

    public ScanDuration length(Integer length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(value="Maximum time the scan can run. If value is zero or less, endDate must be specified for the scan schedule")
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public ScanDuration unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(value="Unit in which duration is specified")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanDuration scanDuration = (ScanDuration)o;
        return Objects.equals(this.length, scanDuration.length) && Objects.equals((Object)this.unit, (Object)scanDuration.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.unit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanDuration {\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        DAY("DAY"),
        HOUR("HOUR"),
        MINUTE("MINUTE");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String text) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            @Override
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

