/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represent the scan recurrence schedule model")
public class ScanRecurrenceSchedule {
    @SerializedName(value="day_of_week")
    private DayOfWeekEnum dayOfWeek = null;
    @SerializedName(value="recurrence_interval")
    private Integer recurrenceInterval = null;
    @SerializedName(value="recurrence_type")
    private RecurrenceTypeEnum recurrenceType = null;
    @SerializedName(value="schedule_end_after")
    private Integer scheduleEndAfter = null;
    @SerializedName(value="week_of_month")
    private WeekOfMonthEnum weekOfMonth = null;

    public ScanRecurrenceSchedule dayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @ApiModelProperty(value="Indicates the day of the week.")
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public ScanRecurrenceSchedule recurrenceInterval(Integer recurrenceInterval) {
        this.recurrenceInterval = recurrenceInterval;
        return this;
    }

    @ApiModelProperty(value="Indicates the time gap between two recurrence.")
    public Integer getRecurrenceInterval() {
        return this.recurrenceInterval;
    }

    public void setRecurrenceInterval(Integer recurrenceInterval) {
        this.recurrenceInterval = recurrenceInterval;
    }

    public ScanRecurrenceSchedule recurrenceType(RecurrenceTypeEnum recurrenceType) {
        this.recurrenceType = recurrenceType;
        return this;
    }

    @ApiModelProperty(value="Indicates the recurrence schedule type")
    public RecurrenceTypeEnum getRecurrenceType() {
        return this.recurrenceType;
    }

    public void setRecurrenceType(RecurrenceTypeEnum recurrenceType) {
        this.recurrenceType = recurrenceType;
    }

    public ScanRecurrenceSchedule scheduleEndAfter(Integer scheduleEndAfter) {
        this.scheduleEndAfter = scheduleEndAfter;
        return this;
    }

    @ApiModelProperty(value="Indicates the end of the recurrence schedule.")
    public Integer getScheduleEndAfter() {
        return this.scheduleEndAfter;
    }

    public void setScheduleEndAfter(Integer scheduleEndAfter) {
        this.scheduleEndAfter = scheduleEndAfter;
    }

    public ScanRecurrenceSchedule weekOfMonth(WeekOfMonthEnum weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
        return this;
    }

    @ApiModelProperty(value="Indicates the week of the month.")
    public WeekOfMonthEnum getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public void setWeekOfMonth(WeekOfMonthEnum weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanRecurrenceSchedule scanRecurrenceSchedule = (ScanRecurrenceSchedule)o;
        return Objects.equals((Object)this.dayOfWeek, (Object)scanRecurrenceSchedule.dayOfWeek) && Objects.equals(this.recurrenceInterval, scanRecurrenceSchedule.recurrenceInterval) && Objects.equals((Object)this.recurrenceType, (Object)scanRecurrenceSchedule.recurrenceType) && Objects.equals(this.scheduleEndAfter, scanRecurrenceSchedule.scheduleEndAfter) && Objects.equals((Object)this.weekOfMonth, (Object)scanRecurrenceSchedule.weekOfMonth);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dayOfWeek, this.recurrenceInterval, this.recurrenceType, this.scheduleEndAfter, this.weekOfMonth});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanRecurrenceSchedule {\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    recurrenceInterval: ").append(this.toIndentedString(this.recurrenceInterval)).append("\n");
        sb.append("    recurrenceType: ").append(this.toIndentedString((Object)this.recurrenceType)).append("\n");
        sb.append("    scheduleEndAfter: ").append(this.toIndentedString(this.scheduleEndAfter)).append("\n");
        sb.append("    weekOfMonth: ").append(this.toIndentedString((Object)this.weekOfMonth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WeekOfMonthEnum {
        FIRST("FIRST"),
        SECOND("SECOND"),
        THIRD("THIRD"),
        FOURTH("FOURTH"),
        LAST("LAST");

        private String value;

        private WeekOfMonthEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WeekOfMonthEnum fromValue(String text) {
            for (WeekOfMonthEnum b : WeekOfMonthEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WeekOfMonthEnum> {
            @Override
            public void write(JsonWriter jsonWriter, WeekOfMonthEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public WeekOfMonthEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WeekOfMonthEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurrenceTypeEnum {
        MONTHLY("MONTHLY"),
        WEEKLY("WEEKLY");

        private String value;

        private RecurrenceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurrenceTypeEnum fromValue(String text) {
            for (RecurrenceTypeEnum b : RecurrenceTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RecurrenceTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, RecurrenceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public RecurrenceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurrenceTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DayOfWeekEnum {
        MONDAY("MONDAY"),
        TUESDAY("TUESDAY"),
        WEDNESDAY("WEDNESDAY"),
        THURSDAY("THURSDAY"),
        FRIDAY("FRIDAY"),
        SATURDAY("SATURDAY"),
        SUNDAY("SUNDAY");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DayOfWeekEnum fromValue(String text) {
            for (DayOfWeekEnum b : DayOfWeekEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DayOfWeekEnum> {
            @Override
            public void write(JsonWriter jsonWriter, DayOfWeekEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public DayOfWeekEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DayOfWeekEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

