/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ApplicationInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ContactInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.InternalScanConfiguration;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanConfigurationRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Representation of a Scan request. A Scan is related to one and only one Application. Additionally a configuration may be specified for use during scanning. If not present the default configuration of the application is used.")
public class ScanRequest {
    @SerializedName(value="action_type")
    private ActionTypeEnum actionType = null;
    @SerializedName(value="scan_id")
    private String scanId = null;
    @SerializedName(value="scan_contact_info")
    private ContactInformation scanContactInfo = null;
    @SerializedName(value="scan_optional_info")
    private ApplicationInformation scanOptionalInfo = null;
    @SerializedName(value="scan_config_request")
    private ScanConfigurationRequest scanConfigRequest = null;
    @SerializedName(value="linked_platform_app_uuid")
    private String linkedPlatformAppUuid = null;
    @SerializedName(value="internal_scan_configuration")
    private InternalScanConfiguration internalScanConfiguration = null;

    public ScanRequest actionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(value="Optional action type, to be used when bulk scan requests are being modified for a single analysis")
    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
    }

    public ScanRequest scanId(String scanId) {
        this.scanId = scanId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the Scan. Needed only for update")
    public String getScanId() {
        return this.scanId;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    public ScanRequest scanContactInfo(ContactInformation scanContactInfo) {
        this.scanContactInfo = scanContactInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ContactInformation getScanContactInfo() {
        return this.scanContactInfo;
    }

    public void setScanContactInfo(ContactInformation scanContactInfo) {
        this.scanContactInfo = scanContactInfo;
    }

    public ScanRequest scanOptionalInfo(ApplicationInformation scanOptionalInfo) {
        this.scanOptionalInfo = scanOptionalInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationInformation getScanOptionalInfo() {
        return this.scanOptionalInfo;
    }

    public void setScanOptionalInfo(ApplicationInformation scanOptionalInfo) {
        this.scanOptionalInfo = scanOptionalInfo;
    }

    public ScanRequest scanConfigRequest(ScanConfigurationRequest scanConfigRequest) {
        this.scanConfigRequest = scanConfigRequest;
        return this;
    }

    @ApiModelProperty(value="")
    public ScanConfigurationRequest getScanConfigRequest() {
        return this.scanConfigRequest;
    }

    public void setScanConfigRequest(ScanConfigurationRequest scanConfigRequest) {
        this.scanConfigRequest = scanConfigRequest;
    }

    public ScanRequest linkedPlatformAppUuid(String linkedPlatformAppUuid) {
        this.linkedPlatformAppUuid = linkedPlatformAppUuid;
        return this;
    }

    @ApiModelProperty(value="UUID of the Platform Application this Scan should be linked to. Optional.")
    public String getLinkedPlatformAppUuid() {
        return this.linkedPlatformAppUuid;
    }

    public void setLinkedPlatformAppUuid(String linkedPlatformAppUuid) {
        this.linkedPlatformAppUuid = linkedPlatformAppUuid;
    }

    public ScanRequest internalScanConfiguration(InternalScanConfiguration internalScanConfiguration) {
        this.internalScanConfiguration = internalScanConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    public InternalScanConfiguration getInternalScanConfiguration() {
        return this.internalScanConfiguration;
    }

    public void setInternalScanConfiguration(InternalScanConfiguration internalScanConfiguration) {
        this.internalScanConfiguration = internalScanConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanRequest scanRequest = (ScanRequest)o;
        return Objects.equals((Object)this.actionType, (Object)scanRequest.actionType) && Objects.equals(this.scanId, scanRequest.scanId) && Objects.equals(this.scanContactInfo, scanRequest.scanContactInfo) && Objects.equals(this.scanOptionalInfo, scanRequest.scanOptionalInfo) && Objects.equals(this.scanConfigRequest, scanRequest.scanConfigRequest) && Objects.equals(this.linkedPlatformAppUuid, scanRequest.linkedPlatformAppUuid) && Objects.equals(this.internalScanConfiguration, scanRequest.internalScanConfiguration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionType, this.scanId, this.scanContactInfo, this.scanOptionalInfo, this.scanConfigRequest, this.linkedPlatformAppUuid, this.internalScanConfiguration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanRequest {\n");
        sb.append("    actionType: ").append(this.toIndentedString((Object)this.actionType)).append("\n");
        sb.append("    scanId: ").append(this.toIndentedString(this.scanId)).append("\n");
        sb.append("    scanContactInfo: ").append(this.toIndentedString(this.scanContactInfo)).append("\n");
        sb.append("    scanOptionalInfo: ").append(this.toIndentedString(this.scanOptionalInfo)).append("\n");
        sb.append("    scanConfigRequest: ").append(this.toIndentedString(this.scanConfigRequest)).append("\n");
        sb.append("    linkedPlatformAppUuid: ").append(this.toIndentedString(this.linkedPlatformAppUuid)).append("\n");
        sb.append("    internalScanConfiguration: ").append(this.toIndentedString(this.internalScanConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionTypeEnum {
        ADD("ADD"),
        UPDATE_SELECTIVE("UPDATE_SELECTIVE"),
        UPDATE_CLOBBER("UPDATE_CLOBBER"),
        REMOVE("REMOVE");

        private String value;

        private ActionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionTypeEnum fromValue(String text) {
            for (ActionTypeEnum b : ActionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ActionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ActionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

