/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class ScanRuntimeSummary {
    @SerializedName(value="build_version")
    private String buildVersion = null;
    @SerializedName(value="bytes_received")
    private Long bytesReceived = null;
    @SerializedName(value="bytes_sent")
    private Long bytesSent = null;
    @SerializedName(value="completed")
    private Boolean completed = null;
    @SerializedName(value="dropped_events")
    private Long droppedEvents = null;
    @SerializedName(value="duration")
    private Long duration = null;
    @SerializedName(value="end")
    private String end = null;
    @SerializedName(value="exit_status")
    private String exitStatus = null;
    @SerializedName(value="free_disk")
    private Long freeDisk = null;
    @SerializedName(value="job_id")
    private String jobId = null;
    @SerializedName(value="links_audited")
    private Long linksAudited = null;
    @SerializedName(value="links_crawled")
    private Long linksCrawled = null;
    @SerializedName(value="login_failures")
    private Long loginFailures = null;
    @SerializedName(value="login_successes")
    private Long loginSuccesses = null;
    @SerializedName(value="network_errors")
    private Long networkErrors = null;
    @SerializedName(value="port_shutdowns")
    private Long portShutdowns = null;
    @SerializedName(value="requests")
    private Long requests = null;
    @SerializedName(value="responses")
    private Long responses = null;
    @SerializedName(value="start")
    private String start = null;

    public ScanRuntimeSummary buildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
        return this;
    }

    @ApiModelProperty(value="The version of the scanner running the job, nullable")
    public String getBuildVersion() {
        return this.buildVersion;
    }

    public void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    public ScanRuntimeSummary bytesReceived(Long bytesReceived) {
        this.bytesReceived = bytesReceived;
        return this;
    }

    @ApiModelProperty(value="The number of bytes received, nullable")
    public Long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(Long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public ScanRuntimeSummary bytesSent(Long bytesSent) {
        this.bytesSent = bytesSent;
        return this;
    }

    @ApiModelProperty(value="The number of bytes sent, nullable")
    public Long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(Long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public ScanRuntimeSummary completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @ApiModelProperty(example="false", value="Is the job completed, defaults false")
    public Boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public ScanRuntimeSummary droppedEvents(Long droppedEvents) {
        this.droppedEvents = droppedEvents;
        return this;
    }

    @ApiModelProperty(value="The number of dropped events, nullable")
    public Long getDroppedEvents() {
        return this.droppedEvents;
    }

    public void setDroppedEvents(Long droppedEvents) {
        this.droppedEvents = droppedEvents;
    }

    public ScanRuntimeSummary duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="The runtime of the job, millis, nullable")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public ScanRuntimeSummary end(String end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(value="The end time of the job, ISO-8601 date time, nullable")
    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public ScanRuntimeSummary exitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
        return this;
    }

    @ApiModelProperty(value="The exit status of the job, nullable, nullable")
    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ScanRuntimeSummary freeDisk(Long freeDisk) {
        this.freeDisk = freeDisk;
        return this;
    }

    @ApiModelProperty(value="The free disk space on the machine running the job, nullable")
    public Long getFreeDisk() {
        return this.freeDisk;
    }

    public void setFreeDisk(Long freeDisk) {
        this.freeDisk = freeDisk;
    }

    public ScanRuntimeSummary jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @ApiModelProperty(value="Job identifer for the running scan")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ScanRuntimeSummary linksAudited(Long linksAudited) {
        this.linksAudited = linksAudited;
        return this;
    }

    @ApiModelProperty(value="The number of links auditted, nullable")
    public Long getLinksAudited() {
        return this.linksAudited;
    }

    public void setLinksAudited(Long linksAudited) {
        this.linksAudited = linksAudited;
    }

    public ScanRuntimeSummary linksCrawled(Long linksCrawled) {
        this.linksCrawled = linksCrawled;
        return this;
    }

    @ApiModelProperty(value="The number of links crawled, nullable")
    public Long getLinksCrawled() {
        return this.linksCrawled;
    }

    public void setLinksCrawled(Long linksCrawled) {
        this.linksCrawled = linksCrawled;
    }

    public ScanRuntimeSummary loginFailures(Long loginFailures) {
        this.loginFailures = loginFailures;
        return this;
    }

    @ApiModelProperty(value="JThe number of failed logins, nullable")
    public Long getLoginFailures() {
        return this.loginFailures;
    }

    public void setLoginFailures(Long loginFailures) {
        this.loginFailures = loginFailures;
    }

    public ScanRuntimeSummary loginSuccesses(Long loginSuccesses) {
        this.loginSuccesses = loginSuccesses;
        return this;
    }

    @ApiModelProperty(value="The number of successful logins, nullable")
    public Long getLoginSuccesses() {
        return this.loginSuccesses;
    }

    public void setLoginSuccesses(Long loginSuccesses) {
        this.loginSuccesses = loginSuccesses;
    }

    public ScanRuntimeSummary networkErrors(Long networkErrors) {
        this.networkErrors = networkErrors;
        return this;
    }

    @ApiModelProperty(value="The number of network errors encountered, nullable")
    public Long getNetworkErrors() {
        return this.networkErrors;
    }

    public void setNetworkErrors(Long networkErrors) {
        this.networkErrors = networkErrors;
    }

    public ScanRuntimeSummary portShutdowns(Long portShutdowns) {
        this.portShutdowns = portShutdowns;
        return this;
    }

    @ApiModelProperty(value="The number of network errors encountered, nullable")
    public Long getPortShutdowns() {
        return this.portShutdowns;
    }

    public void setPortShutdowns(Long portShutdowns) {
        this.portShutdowns = portShutdowns;
    }

    public ScanRuntimeSummary requests(Long requests) {
        this.requests = requests;
        return this;
    }

    @ApiModelProperty(value="The number of requests, nullable")
    public Long getRequests() {
        return this.requests;
    }

    public void setRequests(Long requests) {
        this.requests = requests;
    }

    public ScanRuntimeSummary responses(Long responses) {
        this.responses = responses;
        return this;
    }

    @ApiModelProperty(value="The number of responses received, nullable")
    public Long getResponses() {
        return this.responses;
    }

    public void setResponses(Long responses) {
        this.responses = responses;
    }

    public ScanRuntimeSummary start(String start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(value="The start time of the job, ISO-8601 date time, nullable")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanRuntimeSummary scanRuntimeSummary = (ScanRuntimeSummary)o;
        return Objects.equals(this.buildVersion, scanRuntimeSummary.buildVersion) && Objects.equals(this.bytesReceived, scanRuntimeSummary.bytesReceived) && Objects.equals(this.bytesSent, scanRuntimeSummary.bytesSent) && Objects.equals(this.completed, scanRuntimeSummary.completed) && Objects.equals(this.droppedEvents, scanRuntimeSummary.droppedEvents) && Objects.equals(this.duration, scanRuntimeSummary.duration) && Objects.equals(this.end, scanRuntimeSummary.end) && Objects.equals(this.exitStatus, scanRuntimeSummary.exitStatus) && Objects.equals(this.freeDisk, scanRuntimeSummary.freeDisk) && Objects.equals(this.jobId, scanRuntimeSummary.jobId) && Objects.equals(this.linksAudited, scanRuntimeSummary.linksAudited) && Objects.equals(this.linksCrawled, scanRuntimeSummary.linksCrawled) && Objects.equals(this.loginFailures, scanRuntimeSummary.loginFailures) && Objects.equals(this.loginSuccesses, scanRuntimeSummary.loginSuccesses) && Objects.equals(this.networkErrors, scanRuntimeSummary.networkErrors) && Objects.equals(this.portShutdowns, scanRuntimeSummary.portShutdowns) && Objects.equals(this.requests, scanRuntimeSummary.requests) && Objects.equals(this.responses, scanRuntimeSummary.responses) && Objects.equals(this.start, scanRuntimeSummary.start);
    }

    public int hashCode() {
        return Objects.hash(this.buildVersion, this.bytesReceived, this.bytesSent, this.completed, this.droppedEvents, this.duration, this.end, this.exitStatus, this.freeDisk, this.jobId, this.linksAudited, this.linksCrawled, this.loginFailures, this.loginSuccesses, this.networkErrors, this.portShutdowns, this.requests, this.responses, this.start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanRuntimeSummary {\n");
        sb.append("    buildVersion: ").append(this.toIndentedString(this.buildVersion)).append("\n");
        sb.append("    bytesReceived: ").append(this.toIndentedString(this.bytesReceived)).append("\n");
        sb.append("    bytesSent: ").append(this.toIndentedString(this.bytesSent)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    droppedEvents: ").append(this.toIndentedString(this.droppedEvents)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    exitStatus: ").append(this.toIndentedString(this.exitStatus)).append("\n");
        sb.append("    freeDisk: ").append(this.toIndentedString(this.freeDisk)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    linksAudited: ").append(this.toIndentedString(this.linksAudited)).append("\n");
        sb.append("    linksCrawled: ").append(this.toIndentedString(this.linksCrawled)).append("\n");
        sb.append("    loginFailures: ").append(this.toIndentedString(this.loginFailures)).append("\n");
        sb.append("    loginSuccesses: ").append(this.toIndentedString(this.loginSuccesses)).append("\n");
        sb.append("    networkErrors: ").append(this.toIndentedString(this.networkErrors)).append("\n");
        sb.append("    portShutdowns: ").append(this.toIndentedString(this.portShutdowns)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    responses: ").append(this.toIndentedString(this.responses)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

