/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanBlackoutSchedule;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanDuration;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanRecurrenceSchedule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Representation of a scan schedule")
public class ScanSchedule {
    @SerializedName(value="duration")
    private ScanDuration duration = null;
    @SerializedName(value="effective_end_date")
    private String effectiveEndDate = null;
    @SerializedName(value="effective_start_date")
    private String effectiveStartDate = null;
    @SerializedName(value="end_date")
    private String endDate = null;
    @SerializedName(value="now")
    private Boolean now = null;
    @SerializedName(value="scan_blackout_schedule")
    private ScanBlackoutSchedule scanBlackoutSchedule = null;
    @SerializedName(value="scan_recurrence_schedule")
    private ScanRecurrenceSchedule scanRecurrenceSchedule = null;
    @SerializedName(value="schedule_status")
    private ScheduleStatusEnum scheduleStatus = null;
    @SerializedName(value="start_date")
    private String startDate = null;

    public ScanSchedule duration(ScanDuration duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="Duration of the scan")
    public ScanDuration getDuration() {
        return this.duration;
    }

    public void setDuration(ScanDuration duration) {
        this.duration = duration;
    }

    public ScanSchedule effectiveEndDate(String effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
        return this;
    }

    @ApiModelProperty(value="Present only in response. Represents the effective end date in ISO-8601 format of the Scan as calculated from the schedule specified")
    public String getEffectiveEndDate() {
        return this.effectiveEndDate;
    }

    public void setEffectiveEndDate(String effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public ScanSchedule effectiveStartDate(String effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
        return this;
    }

    @ApiModelProperty(value="Present only in response. Represents the effective start date in ISO-8601 format of the Scan as calculated from the schedule specified")
    public String getEffectiveStartDate() {
        return this.effectiveStartDate;
    }

    public void setEffectiveStartDate(String effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public ScanSchedule endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="If duration is zero or less, must be specified as a date and time in future and the value must be later than startDate. Must be in ISO-8601 format e.g. 2016-12-03T10:15+01:00. Seconds and milliseconds can be included but will be ignored.")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ScanSchedule now(Boolean now) {
        this.now = now;
        return this;
    }

    @ApiModelProperty(value="Indicates if the scan should start as soon as possible")
    public Boolean isNow() {
        return this.now;
    }

    public void setNow(Boolean now) {
        this.now = now;
    }

    public ScanSchedule scanBlackoutSchedule(ScanBlackoutSchedule scanBlackoutSchedule) {
        this.scanBlackoutSchedule = scanBlackoutSchedule;
        return this;
    }

    @ApiModelProperty(value="Scan blackout configuration to schedule auto pause and resume")
    public ScanBlackoutSchedule getScanBlackoutSchedule() {
        return this.scanBlackoutSchedule;
    }

    public void setScanBlackoutSchedule(ScanBlackoutSchedule scanBlackoutSchedule) {
        this.scanBlackoutSchedule = scanBlackoutSchedule;
    }

    public ScanSchedule scanRecurrenceSchedule(ScanRecurrenceSchedule scanRecurrenceSchedule) {
        this.scanRecurrenceSchedule = scanRecurrenceSchedule;
        return this;
    }

    @ApiModelProperty(value="Scan recurrence configuration to schedule batch scans on recurring basis.")
    public ScanRecurrenceSchedule getScanRecurrenceSchedule() {
        return this.scanRecurrenceSchedule;
    }

    public void setScanRecurrenceSchedule(ScanRecurrenceSchedule scanRecurrenceSchedule) {
        this.scanRecurrenceSchedule = scanRecurrenceSchedule;
    }

    public ScanSchedule scheduleStatus(ScheduleStatusEnum scheduleStatus) {
        this.scheduleStatus = scheduleStatus;
        return this;
    }

    @ApiModelProperty(value="Indicates the status of the current schedule, whether active, completed or canceled")
    public ScheduleStatusEnum getScheduleStatus() {
        return this.scheduleStatus;
    }

    public void setScheduleStatus(ScheduleStatusEnum scheduleStatus) {
        this.scheduleStatus = scheduleStatus;
    }

    public ScanSchedule startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="The date and time the scan should start. Must be in ISO-8601 format e.g. 2016-12-03T10:15+01:00. Seconds and milliseconds can be included but will be ignored. If now is set to true, this value is calcuated as the current time, unless already specified")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanSchedule scanSchedule = (ScanSchedule)o;
        return Objects.equals(this.duration, scanSchedule.duration) && Objects.equals(this.effectiveEndDate, scanSchedule.effectiveEndDate) && Objects.equals(this.effectiveStartDate, scanSchedule.effectiveStartDate) && Objects.equals(this.endDate, scanSchedule.endDate) && Objects.equals(this.now, scanSchedule.now) && Objects.equals(this.scanBlackoutSchedule, scanSchedule.scanBlackoutSchedule) && Objects.equals(this.scanRecurrenceSchedule, scanSchedule.scanRecurrenceSchedule) && Objects.equals((Object)this.scheduleStatus, (Object)scanSchedule.scheduleStatus) && Objects.equals(this.startDate, scanSchedule.startDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.effectiveEndDate, this.effectiveStartDate, this.endDate, this.now, this.scanBlackoutSchedule, this.scanRecurrenceSchedule, this.scheduleStatus, this.startDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanSchedule {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    effectiveEndDate: ").append(this.toIndentedString(this.effectiveEndDate)).append("\n");
        sb.append("    effectiveStartDate: ").append(this.toIndentedString(this.effectiveStartDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    now: ").append(this.toIndentedString(this.now)).append("\n");
        sb.append("    scanBlackoutSchedule: ").append(this.toIndentedString(this.scanBlackoutSchedule)).append("\n");
        sb.append("    scanRecurrenceSchedule: ").append(this.toIndentedString(this.scanRecurrenceSchedule)).append("\n");
        sb.append("    scheduleStatus: ").append(this.toIndentedString((Object)this.scheduleStatus)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScheduleStatusEnum {
        ACTIVE("ACTIVE"),
        CANCELED("CANCELED"),
        COMPLETED("COMPLETED");

        private String value;

        private ScheduleStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScheduleStatusEnum fromValue(String text) {
            for (ScheduleStatusEnum b : ScheduleStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ScheduleStatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ScheduleStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ScheduleStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScheduleStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

