/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Representation of an URL for the purpose of scanning. Contains additional details on how the scan should handle the URL")
public class ScanURL {
    @SerializedName(value="directory_restriction_type")
    private DirectoryRestrictionTypeEnum directoryRestrictionType = null;
    @SerializedName(value="http_and_https")
    private Boolean httpAndHttps = null;
    @SerializedName(value="url")
    private String url = null;

    public ScanURL directoryRestrictionType(DirectoryRestrictionTypeEnum directoryRestrictionType) {
        this.directoryRestrictionType = directoryRestrictionType;
        return this;
    }

    @ApiModelProperty(example="DIRECTORY_AND_SUBDIRECTORY", value="Directories to restrict scope during scanning. Default is DIRECTORY AND SUBDIRECTORY")
    public DirectoryRestrictionTypeEnum getDirectoryRestrictionType() {
        return this.directoryRestrictionType;
    }

    public void setDirectoryRestrictionType(DirectoryRestrictionTypeEnum directoryRestrictionType) {
        this.directoryRestrictionType = directoryRestrictionType;
    }

    public ScanURL httpAndHttps(Boolean httpAndHttps) {
        this.httpAndHttps = httpAndHttps;
        return this;
    }

    @ApiModelProperty(example="true", value="If true - both HTTP and HTTPS protocols apply even if the base url is only one of those. Default is true.")
    public Boolean isHttpAndHttps() {
        return this.httpAndHttps;
    }

    public void setHttpAndHttps(Boolean httpAndHttps) {
        this.httpAndHttps = httpAndHttps;
    }

    public ScanURL url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Base URL, must be valid")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanURL scanURL = (ScanURL)o;
        return Objects.equals((Object)this.directoryRestrictionType, (Object)scanURL.directoryRestrictionType) && Objects.equals(this.httpAndHttps, scanURL.httpAndHttps) && Objects.equals(this.url, scanURL.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.directoryRestrictionType, this.httpAndHttps, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanURL {\n");
        sb.append("    directoryRestrictionType: ").append(this.toIndentedString((Object)this.directoryRestrictionType)).append("\n");
        sb.append("    httpAndHttps: ").append(this.toIndentedString(this.httpAndHttps)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectoryRestrictionTypeEnum {
        DIRECTORY_AND_SUBDIRECTORY("DIRECTORY_AND_SUBDIRECTORY"),
        FOLDER_ONLY("FOLDER_ONLY"),
        FILE("FILE"),
        NONE("NONE");

        private String value;

        private DirectoryRestrictionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectoryRestrictionTypeEnum fromValue(String text) {
            for (DirectoryRestrictionTypeEnum b : DirectoryRestrictionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DirectoryRestrictionTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, DirectoryRestrictionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public DirectoryRestrictionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectoryRestrictionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

