/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Visibility setup rules for an analysis")
public class VisibilitySetup {
    @SerializedName(value="setup_type")
    private SetupTypeEnum setupType = null;
    @SerializedName(value="team_identifiers")
    private List<String> teamIdentifiers = null;

    public VisibilitySetup setupType(SetupTypeEnum setupType) {
        this.setupType = setupType;
        return this;
    }

    @ApiModelProperty(value="Setup type")
    public SetupTypeEnum getSetupType() {
        return this.setupType;
    }

    public void setSetupType(SetupTypeEnum setupType) {
        this.setupType = setupType;
    }

    public VisibilitySetup teamIdentifiers(List<String> teamIdentifiers) {
        this.teamIdentifiers = teamIdentifiers;
        return this;
    }

    public VisibilitySetup addTeamIdentifiersItem(String teamIdentifiersItem) {
        if (this.teamIdentifiers == null) {
            this.teamIdentifiers = new ArrayList<String>();
        }
        this.teamIdentifiers.add(teamIdentifiersItem);
        return this;
    }

    @ApiModelProperty(value="Identifiers of teams that have access")
    public List<String> getTeamIdentifiers() {
        return this.teamIdentifiers;
    }

    public void setTeamIdentifiers(List<String> teamIdentifiers) {
        this.teamIdentifiers = teamIdentifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisibilitySetup visibilitySetup = (VisibilitySetup)o;
        return Objects.equals((Object)this.setupType, (Object)visibilitySetup.setupType) && Objects.equals(this.teamIdentifiers, visibilitySetup.teamIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.setupType, this.teamIdentifiers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VisibilitySetup {\n");
        sb.append("    setupType: ").append(this.toIndentedString((Object)this.setupType)).append("\n");
        sb.append("    teamIdentifiers: ").append(this.toIndentedString(this.teamIdentifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SetupTypeEnum {
        ONLY("SEC_LEADS_ONLY"),
        AND_TEAM("SEC_LEADS_AND_TEAM");

        private String value;

        private SetupTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SetupTypeEnum fromValue(String text) {
            for (SetupTypeEnum b : SetupTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SetupTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, SetupTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SetupTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SetupTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

