/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.rest;

import com.veracode.util.lang.StringUtility;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ApiEndpoint {
    private String uri;
    private Set<String> arguments;
    private Set<String> allowedParams;

    public boolean allows(Collection<String> param) {
        return this.allowedParams.containsAll(param);
    }

    private String replaceUriArguments(Map<String, String> args) {
        String result = this.getBaseUri();
        if (null == args || args.isEmpty()) {
            return result;
        }
        for (String arg : this.arguments) {
            if (StringUtility.isNullOrEmpty(arg)) continue;
            String key = "{" + arg + "}";
            String value = args.get(arg);
            if (StringUtility.isNullOrEmpty(value)) continue;
            result = result.replace(key, value);
        }
        return result;
    }

    public String generateUri(Map<String, String> arguments, Map<String, String> query) {
        if (null != query && !this.allows(query.keySet())) {
            throw new IllegalArgumentException("Invalid arguments to invoke " + this.uri);
        }
        StringBuilder resultBuilder = new StringBuilder(this.replaceUriArguments(arguments));
        if (null != query) {
            int separator = 63;
            for (Map.Entry<String, String> entry : query.entrySet()) {
                if (StringUtility.isNullOrEmpty(entry.getKey())) continue;
                resultBuilder.append((char)separator);
                resultBuilder.append(entry.getKey());
                resultBuilder.append("=");
                resultBuilder.append(StringUtility.isNullOrEmpty(entry.getValue()) ? "" : entry.getValue());
                separator = 38;
            }
        }
        return resultBuilder.toString();
    }

    private ApiEndpoint() {
    }

    public String getBaseUri() {
        return this.uri;
    }

    public Set<String> getArguments() {
        return this.arguments;
    }

    public Set<String> getAllowedParameters() {
        return this.allowedParams;
    }

    public static class Builder {
        private String uri;
        private Set<String> arguments;
        private Set<String> allowedParams;

        public Builder(String uri) {
            this.uri = uri;
        }

        public Builder withArguments(Set<String> arguments) {
            this.arguments = null == arguments ? new HashSet<String>() : new HashSet<String>(arguments);
            return this;
        }

        public Builder allowsParameters(Set<String> parameters) {
            this.allowedParams = null == parameters ? new HashSet<String>() : new HashSet<String>(parameters);
            return this;
        }

        public ApiEndpoint build() {
            ApiEndpoint endpoint = new ApiEndpoint();
            endpoint.uri = this.uri;
            endpoint.arguments = null != this.arguments ? Collections.unmodifiableSet(this.arguments) : Collections.emptySet();
            endpoint.allowedParams = null != this.allowedParams ? Collections.unmodifiableSet(this.allowedParams) : Collections.emptySet();
            return endpoint;
        }
    }
}

