/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.veracode.apiwrapper.exceptions.InitializationException;
import com.veracode.apiwrapper.services.CredentialsService;
import com.veracode.http.Credentials;
import com.veracode.parser.util.StringUtility;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class DefaultCredentialsService
implements CredentialsService {
    private static final String DEFAULT_CREDENTIALS_FILE_PATH = System.getProperty("user.home") + File.separator + ".veracode" + File.separator + "credentials";
    private static final String ID_PROPERTY_NAME = "veracode_api_key_id";
    private static final String KEY_PROPERTY_NAME = "veracode_api_key_secret";
    private static final String DEFAULT_SECTION = "default";
    private static final String API_ID_ENV_VAR = "VERACODE_API_KEY_ID";
    private static final String API_KEY_ENV_VAR = "VERACODE_API_KEY_SECRET";
    private String error = null;
    private Ini credentialsSections = null;
    private Optional<Credentials> env = null;

    @Override
    public Optional<Credentials> getCredentials() {
        return this.env.isPresent() ? this.env : this.getDefaultCredentials();
    }

    @Override
    public Optional<Credentials> getDefaultCredentials() {
        return this.getCredentials(null);
    }

    @Override
    public Optional<Credentials> getCredentials(String profile) {
        if (null == this.credentialsSections) {
            if (null != this.error) {
                throw new InitializationException("There was an error when reading the credentials file: [" + this.error + "]");
            }
            return Optional.ofNullable(null);
        }
        Credentials result = null;
        if (StringUtility.isNullOrEmpty(profile)) {
            Profile.Section defaultSection = DefaultCredentialsService.getDefaultSection(this.credentialsSections);
            if (null != defaultSection) {
                result = Credentials.create((String)defaultSection.get(ID_PROPERTY_NAME), (String)defaultSection.get(KEY_PROPERTY_NAME));
            }
        } else {
            Profile.Section section = (Profile.Section)this.credentialsSections.get(profile.toLowerCase());
            if (null != section) {
                result = Credentials.create((String)section.get(ID_PROPERTY_NAME), (String)section.get(KEY_PROPERTY_NAME));
            }
        }
        return Optional.ofNullable(result);
    }

    public static CredentialsService createInstance() {
        return DefaultCredentialsService.createInstance(new File(DEFAULT_CREDENTIALS_FILE_PATH));
    }

    public static CredentialsService createInstance(File credFile) {
        DefaultCredentialsService svc = new DefaultCredentialsService();
        try {
            svc.credentialsSections = DefaultCredentialsService.initCredentialsFromFile(null == credFile ? new File(DEFAULT_CREDENTIALS_FILE_PATH) : credFile);
        }
        catch (IOException | IllegalArgumentException e) {
            svc.error = e.getClass().getName() + ": " + e.getMessage();
        }
        svc.env = DefaultCredentialsService.getCredentialsFromEnv();
        return svc;
    }

    private static final Optional<Credentials> getCredentialsFromEnv() {
        String id = System.getenv(API_ID_ENV_VAR);
        String key = System.getenv(API_KEY_ENV_VAR);
        Credentials result = null;
        try {
            result = Credentials.create(id, key);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.ofNullable(result);
    }

    private static final Ini initCredentialsFromFile(File credFile) throws IOException {
        if (null == credFile || !credFile.exists()) {
            return null;
        }
        if (!(credFile.isFile() && credFile.isAbsolute() && credFile.canRead())) {
            throw new IllegalArgumentException("The credentials file [" + credFile.getPath() + "] is invalid.");
        }
        Config config = new Config();
        config.setLowerCaseSection(true);
        config.setLowerCaseOption(true);
        Ini creds = new Ini();
        creds.setConfig(config);
        creds.load(credFile);
        return creds;
    }

    private static Profile.Section getDefaultSection(Ini credentials) {
        if (null == credentials || 0 == credentials.size()) {
            return null;
        }
        return credentials.size() == 1 ? (Profile.Section)credentials.get(credentials.keySet().iterator().next()) : (Profile.Section)credentials.get(DEFAULT_SECTION);
    }

    private DefaultCredentialsService() {
    }
}

