/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.veracode.apiwrapper.services.ProxyService;
import com.veracode.http.proxy.ProxyData;
import com.veracode.http.util.ProxyAuthenticator;
import com.veracode.util.lang.StringUtility;
import java.net.Proxy;
import java.util.Optional;

public class DefaultProxyService
implements ProxyService {
    private static final String HTTPS_PROXY_ENV_VAR = "https_proxy";
    private Optional<Proxy> env = null;

    @Override
    public Optional<Proxy> getProxy() {
        return this.env.isPresent() ? this.env : Optional.ofNullable(null);
    }

    public static ProxyService createInstance() {
        DefaultProxyService svc = new DefaultProxyService();
        svc.env = DefaultProxyService.getProxyFromEnv();
        return svc;
    }

    private static final Optional<Proxy> getProxyFromEnv() {
        Proxy result;
        block3: {
            String proxyEnvVar = System.getenv(HTTPS_PROXY_ENV_VAR);
            if (StringUtility.isNullOrEmpty(proxyEnvVar)) {
                proxyEnvVar = System.getenv(HTTPS_PROXY_ENV_VAR.toUpperCase());
            }
            result = null;
            try {
                result = ProxyAuthenticator.newProxy(ProxyData.create(proxyEnvVar));
            }
            catch (IllegalArgumentException iae) {
                if (iae.getMessage().equals("The proxy is not specified.")) break block3;
                throw iae;
            }
        }
        return Optional.ofNullable(result);
    }

    private DefaultProxyService() {
    }
}

