/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services.impl;

import com.google.gson.Gson;
import com.veracode.apiwrapper.services.RegionService;
import com.veracode.http.Region;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultRegionService
implements RegionService {
    private static final String GLOBAL_NAME = "global";
    private static final String GLOBAL_ID_PREFIX = "vera01gi";
    private static final String GLOBAL_KEY_PREFIX = "vera01gs";
    private static final String GLOBAL_XML_API_HOST = "analysiscenter.veracode.com";
    private static final String GLOBAL_REST_API_HOST = "api.veracode.com";
    private static final Regions regions = DefaultRegionService.initRegions();

    @Override
    public Set<Region> getRegions() {
        return DefaultRegionService.regions.getRegions();
    }

    @Override
    public Region getDefaultRegion() {
        return DefaultRegionService.regions.getDefaultRegion().orElse(new Region(GLOBAL_NAME, GLOBAL_ID_PREFIX, GLOBAL_KEY_PREFIX, GLOBAL_XML_API_HOST, GLOBAL_REST_API_HOST, true));
    }

    @Override
    public Optional<Region> getRegionByName(String name) {
        return DefaultRegionService.regions.getRegionByName(name);
    }

    @Override
    public Optional<Region> getRegionByIdPrefix(String prefix) {
        return DefaultRegionService.regions.getRegionByIdPrefix(prefix);
    }

    @Override
    public Optional<Region> getRegionByKeyPrefix(String prefix) {
        return DefaultRegionService.regions.getRegionByKeyPrefix(prefix);
    }

    @Override
    public Set<Region> getInvalidRegions() {
        return DefaultRegionService.regions.getInvalidRegions();
    }

    private static Regions initRegions() {
        Regions result;
        try {
            result = new Gson().fromJson(DefaultRegionService.getRegionJson(), Regions.class);
            result.validateRegions();
        }
        catch (IOException e) {
            result = new Regions();
        }
        if (!result.getDefaultRegion().isPresent()) {
            result.addRegion(new Region(GLOBAL_NAME, GLOBAL_ID_PREFIX, GLOBAL_KEY_PREFIX, GLOBAL_XML_API_HOST, GLOBAL_REST_API_HOST, true));
        }
        return result;
    }

    private static String getRegionJson() throws IOException {
        String json = "";
        ClassLoader loader = DefaultRegionService.class.getClassLoader();
        try (InputStream regionsJSONStream = loader.getResourceAsStream("veracode.regions.json");
             InputStreamReader regionJSONStreamReader = new InputStreamReader(regionsJSONStream);
             BufferedReader regionJSONReader = new BufferedReader(regionJSONStreamReader);){
            json = regionJSONReader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return json;
    }

    private static class Regions {
        private Set<Region> regions = new HashSet<Region>();
        private Set<Region> invalidRegions = new HashSet<Region>();

        private Regions() {
        }

        private void addRegion(Region region) {
            if (null != region) {
                this.regions.add(region);
            }
        }

        private Set<Region> getRegions() {
            return this.regions;
        }

        private Set<Region> getInvalidRegions() {
            return this.invalidRegions;
        }

        private Optional<Region> getDefaultRegion() {
            return this.regions.stream().filter(Region::isDefault).findFirst();
        }

        private Optional<Region> getRegionByName(String name) {
            return this.regions.stream().filter(r -> r.getName().equalsIgnoreCase(name)).findFirst();
        }

        private Optional<Region> getRegionByIdPrefix(String prefix) {
            return this.regions.stream().filter(r -> r.getIdPrefix().equalsIgnoreCase(prefix)).findFirst();
        }

        private Optional<Region> getRegionByKeyPrefix(String prefix) {
            return this.regions.stream().filter(r -> r.getKeyPrefix().equalsIgnoreCase(prefix)).findFirst();
        }

        private void validateRegions() {
            this.invalidRegions = this.regions.stream().filter(r -> !r.isValid()).collect(Collectors.toSet());
            this.regions = this.regions.stream().filter(Region::isValid).collect(Collectors.toSet());
        }
    }
}

