/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.transformer;

import com.veracode.apiwrapper.application.model.api.Application;
import com.veracode.apiwrapper.application.model.api.ApplicationScan;
import com.veracode.apiwrapper.application.model.api.CustomNameValue;
import com.veracode.apiwrapper.application.model.client.ApplicationInfo;
import com.veracode.apiwrapper.application.model.client.CustomField;
import com.veracode.apiwrapper.application.model.client.Scan;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisOccurrence;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisOccurrenceStatus;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisSummary;
import com.veracode.apiwrapper.dynamicanalysis.model.api.DetailedScanOccurrence;
import com.veracode.apiwrapper.dynamicanalysis.model.api.EmbeddedErrorData;
import com.veracode.apiwrapper.dynamicanalysis.model.api.LinkedAppInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanOccurrenceStatus;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ServiceError;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisOccurrenceInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisOccurrenceStatusInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.EmbeddedErrorDataInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.LinkedAppData;
import com.veracode.apiwrapper.dynamicanalysis.model.client.ScanOccurrenceInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.ScanOccurrenceStatusInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.ServiceErrorInfo;
import com.veracode.util.lang.StringUtility;
import java.util.ArrayList;
import java.util.List;

public class APIToClientModelTransformer {
    public static AnalysisInfo transform(AnalysisSummary analysisSummary) {
        if (null == analysisSummary) {
            return null;
        }
        String id = analysisSummary.getAnalysisId();
        if (!StringUtility.validateGUID(id)) {
            throw new IllegalArgumentException("The analysis ID is invalid.");
        }
        String name = analysisSummary.getName();
        String analysisOccurrenceId = analysisSummary.getLatestOccurrenceId();
        AnalysisOccurrenceStatusInfo statusInfo = APIToClientModelTransformer.transform(analysisSummary.getLatestOccurrenceStatus());
        List<String> capabilities = analysisSummary.getUserCapabilites();
        AnalysisInfo analysisInfo = new AnalysisInfo(id, name, analysisOccurrenceId, statusInfo, capabilities);
        return analysisInfo;
    }

    public static AnalysisOccurrenceStatusInfo transform(AnalysisOccurrenceStatus analysisOccurrenceStatus) {
        if (null == analysisOccurrenceStatus) {
            return null;
        }
        AnalysisOccurrenceStatus.StatusTypeEnum description = analysisOccurrenceStatus.getStatusType();
        AnalysisOccurrenceStatusInfo.StatusTypeEnum status = null;
        for (AnalysisOccurrenceStatusInfo.StatusTypeEnum statusTypeEnum : AnalysisOccurrenceStatusInfo.StatusTypeEnum.values()) {
            if (!description.toString().equalsIgnoreCase(statusTypeEnum.toString())) continue;
            status = statusTypeEnum;
            break;
        }
        AnalysisOccurrenceStatusInfo statusInfo = new AnalysisOccurrenceStatusInfo(status);
        return statusInfo;
    }

    public static AnalysisOccurrenceInfo transform(AnalysisOccurrence analysisOccurrence) {
        if (null == analysisOccurrence) {
            return null;
        }
        String id = analysisOccurrence.getAnalysisId();
        String occurrenceId = analysisOccurrence.getAnalysisOccurrenceId();
        if (!StringUtility.validateGUID(id) || !StringUtility.validateGUID(occurrenceId)) {
            throw new IllegalArgumentException("The Analysis Occurrence contains invalid ID.");
        }
        AnalysisOccurrenceStatusInfo statusInfo = APIToClientModelTransformer.transform(analysisOccurrence.getStatus());
        AnalysisOccurrenceInfo analysisOccurrenceInfo = new AnalysisOccurrenceInfo(id, occurrenceId, statusInfo);
        return analysisOccurrenceInfo;
    }

    public static EmbeddedErrorDataInfo transform(EmbeddedErrorData error) {
        if (null == error) {
            return null;
        }
        EmbeddedErrorDataInfo embeddedErrorDataInfo = new EmbeddedErrorDataInfo();
        ArrayList<ServiceErrorInfo> serviceErrorInfoList = new ArrayList<ServiceErrorInfo>();
        List<Object> serviceErrorList = new ArrayList();
        serviceErrorList = error.getEmbedded().getErrors();
        for (ServiceError serviceError : serviceErrorList) {
            ServiceErrorInfo.CodeEnum errorCode = ServiceErrorInfo.CodeEnum.INTERNAL_ERROR;
            if (null != serviceError.getCode()) {
                errorCode = ServiceErrorInfo.CodeEnum.fromValue(serviceError.getCode().getValue());
            }
            String metaData = null;
            if (null != serviceError.getMeta()) {
                metaData = serviceError.getMeta().toString();
            }
            String parameter = null;
            if (null != serviceError.getSource()) {
                parameter = serviceError.getSource().getParameter();
            }
            ServiceErrorInfo se = new ServiceErrorInfo(errorCode, serviceError.getTitle(), serviceError.getDetail(), metaData, serviceError.getStatus(), parameter);
            serviceErrorInfoList.add(se);
        }
        embeddedErrorDataInfo.setErrors(serviceErrorInfoList);
        return embeddedErrorDataInfo;
    }

    public static ScanOccurrenceInfo transform(DetailedScanOccurrence detailedScanOccurrence) {
        if (null == detailedScanOccurrence) {
            return null;
        }
        ScanOccurrenceStatusInfo statusInfo = APIToClientModelTransformer.transform(detailedScanOccurrence.getStatus());
        LinkedAppData linkedAppData = APIToClientModelTransformer.transform(detailedScanOccurrence.getLinkedAppInfo());
        ScanOccurrenceInfo scanOccurInfo = new ScanOccurrenceInfo(detailedScanOccurrence.getScanOccurrenceId(), detailedScanOccurrence.getAnalysisId(), detailedScanOccurrence.getAnalysisOccurrenceId(), detailedScanOccurrence.getAnalysisName(), detailedScanOccurrence.getCountOfLowSevFlaws(), detailedScanOccurrence.getCountOfMediumSevFlaws(), detailedScanOccurrence.getCountOfHighSevFlaws(), detailedScanOccurrence.getCountOfVeryHighSevFlaws(), detailedScanOccurrence.getTotalFlawCount(), linkedAppData, detailedScanOccurrence.getLinkedPlatformAppName(), detailedScanOccurrence.getLinkedPlatformAppId(), detailedScanOccurrence.getLinkedPlatformAppUuid(), detailedScanOccurrence.getTargetUrl(), statusInfo);
        return scanOccurInfo;
    }

    public static ApplicationInfo transform(Application application) {
        if (null == application) {
            return null;
        }
        ArrayList<Scan> scanResult = new ArrayList<Scan>();
        for (ApplicationScan scan : application.getScans()) {
            String[] scanUrlData;
            String buildId = null;
            if (!StringUtility.isNullOrEmpty(scan.getScanUrl()) && (scanUrlData = scan.getScanUrl().split(":")).length >= 4) {
                buildId = scanUrlData[3];
            }
            String scanType = scan.getScanType() != null ? scan.getScanType().getValue() : null;
            String scanStatus = scan.getStatus() != null ? scan.getStatus().getValue() : null;
            scanResult.add(new Scan(scanType, scanStatus, scan.getModifiedDate(), scan.getScanUrl(), scan.getInternalStatus(), buildId));
        }
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        if (application.getProfile().getCustomFields() != null) {
            for (CustomNameValue appCustomFieldValue : application.getProfile().getCustomFields()) {
                customFields.add(new CustomField(appCustomFieldValue.getName(), appCustomFieldValue.getValue()));
            }
        }
        return new ApplicationInfo(application.getId(), application.getOid(), application.getProfile().getName(), application.getModified(), application.getLastCompletedScanDate(), application.getLastPolicyComplianceCheckDate(), application.getProfile().getBusinessCriticality().getValue(), customFields, scanResult);
    }

    private static ScanOccurrenceStatusInfo transform(ScanOccurrenceStatus status) {
        if (null == status) {
            return null;
        }
        ScanOccurrenceStatusInfo result = new ScanOccurrenceStatusInfo(ScanOccurrenceStatusInfo.StatusTypeEnum.fromValue(status.getStatusType().getValue()));
        return result;
    }

    private static LinkedAppData transform(LinkedAppInfo linkedAppInfo) {
        if (null == linkedAppInfo) {
            return null;
        }
        LinkedAppData linkedAppData = new LinkedAppData(linkedAppInfo.getAppVerId(), linkedAppInfo.getAnalysisUnitId(), linkedAppInfo.getResultImportRequestStatus());
        return linkedAppData;
    }
}

