/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.utils;

import com.veracode.apiwrapper.services.ServiceManager;
import com.veracode.http.Region;
import com.veracode.parser.util.XmlUtils;

public class PlatformLinkUtils {
    private static final String PAGE_PREFIX_FORMAT = "%s%s#%s";
    private static final String BASE_ADDRESS_FORMAT = "https://%s/";

    public static String getPlatformPageURL(TargetPages targetPage, String buildInfoXml, Region region) throws Exception {
        Region baseAddressRegion = region;
        if (null == targetPage || null == buildInfoXml) {
            throw new IllegalArgumentException("Cannot create a link with the given arguments");
        }
        if (null == region) {
            baseAddressRegion = ServiceManager.getRegionService().getDefaultRegion();
        }
        String baseAddress = String.format(BASE_ADDRESS_FORMAT, baseAddressRegion.getXmlApiHost());
        return targetPage.getFormattedPrefix(baseAddress) + targetPage.getFormattedSuffix(XmlUtils.parseAccountId(buildInfoXml), XmlUtils.parseAppId(buildInfoXml), XmlUtils.parseBuildId(buildInfoXml));
    }

    private PlatformLinkUtils() {
    }

    public static enum TargetPages {
        VIEW_HOME_APP_PROFILE("HomeAppProfile", ":%s:%s"),
        VIEW_DETAILED_REPORT("ViewReportsDetailedReport", ":%s:%s:%s");

        private final String suffixFormat;
        private final String tag;

        private TargetPages(String tag, String suffixFormat) {
            this.suffixFormat = suffixFormat;
            this.tag = tag;
        }

        private String getFormattedSuffix(long acctId, long appId, long buildId) {
            return String.format(this.suffixFormat, acctId, appId, buildId);
        }

        private String getFormattedPrefix(String baseUrl) {
            return String.format(PlatformLinkUtils.PAGE_PREFIX_FORMAT, baseUrl, "auth/index.jsp", this.tag);
        }
    }
}

