/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.wrappers;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.http.util.HttpUtility;
import java.io.IOException;
import java.util.HashMap;

public final class SandboxAPIWrapper
extends AbstractAPIWrapper {
    public static final String CREATE_SANDBOX_URI = "api/5.0/createsandbox.do";
    public static final String GET_SANDBOX_LIST_URI = "api/5.0/getsandboxlist.do";
    public static final String PROMOTE_SANDBOX_URI = "api/5.0/promotesandbox.do";
    public static final String UPDATE_SANDBOX_URI = "api/5.0/updatesandbox.do";
    public static final String DELETE_SANDBOX_URI = "api/5.0/deletesandbox.do";

    public String createSandbox(String app_id, String sandbox_name) throws IOException {
        return this.createSandbox(app_id, sandbox_name, false);
    }

    public String createSandbox(String appId, String sandboxName, Boolean autoRecreate) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (appId != null) {
            queryString.put("app_id", HttpUtility.urlEncode(appId));
        }
        if (sandboxName != null) {
            queryString.put("sandbox_name", HttpUtility.urlEncode(sandboxName));
        }
        if (autoRecreate != null) {
            queryString.put("auto_recreate", autoRecreate);
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(CREATE_SANDBOX_URI);
    }

    public String getSandboxList(String app_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (app_id != null) {
            queryString.put("app_id", HttpUtility.urlEncode(app_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_SANDBOX_LIST_URI);
    }

    public String promoteSandbox(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(PROMOTE_SANDBOX_URI);
    }

    public String updateSandbox(String sandbox_id, String custom_field_name, String custom_field_value) throws IOException {
        return this.updateSandbox(sandbox_id, custom_field_name, custom_field_value, false);
    }

    public String updateSandbox(String sandboxId, String customFieldName, String customFieldValue, Boolean autoRecreate) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (sandboxId != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandboxId));
        }
        if (customFieldName != null) {
            queryString.put("custom_field_name", HttpUtility.urlEncode(customFieldName));
        }
        if (customFieldValue != null) {
            queryString.put("custom_field_value", HttpUtility.urlEncode(customFieldValue));
        }
        if (autoRecreate != null) {
            queryString.put("auto_recreate", autoRecreate);
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(UPDATE_SANDBOX_URI);
    }

    public String deleteSandbox(String sandboxId) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (sandboxId != null) {
            queryString.put("sandbox_id", HttpUtility.urlEncode(sandboxId));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DELETE_SANDBOX_URI);
    }
}

