/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.http.events.UploadProgressChangedEventArgs;
import com.veracode.http.events.UploadProgressChangedListener;
import com.veracode.http.proxy.ProxyData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public abstract class WebRequestHandler {
    private static final String DELIMITER = "--";
    private static final String CRLF = "\r\n";
    protected static final int CHUNK_SIZE = 65536;
    private boolean verbose;
    protected PrintStream outputWriter = System.out;

    public abstract void makeFormUrlEncodedPostRequest(String var1, String var2) throws IOException;

    public abstract void makeOctetStreamPostRequest(File var1, boolean var2, UploadProgressChangedListener var3) throws IOException;

    public abstract void makeMultiPartPostRequest(Map<String, Object> var1, String var2, String var3, boolean var4, UploadProgressChangedListener var5) throws IOException;

    public abstract void init(URL var1, ProxyData var2) throws IOException;

    public abstract void setConnectTimeout(int var1);

    public abstract void setReadTimeout(int var1);

    public abstract void addHeader(String var1, String var2);

    public abstract void addUserAgentHeader(String var1);

    public abstract String getDefaultUserAgentHeaderValue();

    public abstract byte[] getResponse() throws IOException;

    public abstract int getResponseCode() throws IOException;

    public abstract int getUnauthorizedResponseCodeConstant();

    public abstract boolean releaseResources();

    protected void writeFile(OutputStream requestOutputStream, InputStream fileInputStream, long totalBytesToSend, UploadProgressChangedListener listener) throws IOException {
        if (requestOutputStream != null && fileInputStream != null) {
            int bufferSize = 65536;
            int bytesRead = -1;
            int bytesSent = 0;
            int lastProgressPercentage = 0;
            int lastDiscreteProgressPercentage = 0;
            if (totalBytesToSend > 0L) {
                this.debugWriteLine(String.format("Content length in bytes to upload:  %s", totalBytesToSend));
                if (listener != null) {
                    listener.uploadProgressChanged(new UploadProgressChangedEventArgs(0, 0L, totalBytesToSend, true));
                }
            }
            byte[] bytes = new byte[bufferSize];
            while ((bytesRead = fileInputStream.read(bytes, 0, bytes.length)) != -1) {
                int p;
                requestOutputStream.write(bytes, 0, bytesRead);
                requestOutputStream.flush();
                if (totalBytesToSend <= 0L || (p = (int)(1.0 * (double)(bytesSent += bytesRead) / (double)totalBytesToSend * 100.0)) <= lastProgressPercentage || p > 100) continue;
                if (p >= lastDiscreteProgressPercentage + 5 || p == 100) {
                    this.debugWriteLine(String.format("Total bytes uploaded:  %s / %s [%s%%]", bytesSent, totalBytesToSend, p));
                    lastDiscreteProgressPercentage = p;
                }
                lastProgressPercentage = p;
                if (listener == null) continue;
                listener.uploadProgressChanged(new UploadProgressChangedEventArgs(p, bytesSent, totalBytesToSend, lastDiscreteProgressPercentage == p));
            }
        }
    }

    protected void writeText(OutputStream requestOutputStream, String text, String encoding) throws IOException {
        byte[] bytes;
        if (requestOutputStream != null && text != null && (bytes = text.getBytes(encoding)) != null) {
            requestOutputStream.write(bytes, 0, bytes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMultiPartPostRequestBody(OutputStream requestOutputStream, String boundaryString, Map<String, Object> formParameters, String encoding, UploadProgressChangedListener listener) throws IOException {
        if (formParameters != null && formParameters.size() > 0) {
            for (Map.Entry<String, Object> parameter : formParameters.entrySet()) {
                if (parameter == null) continue;
                String paramName = parameter.getKey();
                Object paramValue = parameter.getValue();
                if (paramName == null || paramValue == null) continue;
                if (paramValue instanceof File) {
                    FileInputStream fileInputStream = new FileInputStream((File)paramValue);
                    try {
                        String contentType = HttpURLConnection.guessContentTypeFromName(((File)paramValue).getPath());
                        this.writeText(requestOutputStream, DELIMITER + boundaryString + CRLF, encoding);
                        this.writeText(requestOutputStream, String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", paramName, ((File)paramValue).getPath()) + CRLF, encoding);
                        this.writeText(requestOutputStream, String.format("Content-Type: %s", contentType != null ? contentType : "application/octet-stream") + CRLF + CRLF, encoding);
                        this.writeFile(requestOutputStream, fileInputStream, ((File)paramValue).length(), listener);
                        this.writeText(requestOutputStream, CRLF, encoding);
                        continue;
                    }
                    finally {
                        fileInputStream.close();
                        continue;
                    }
                }
                this.writeText(requestOutputStream, DELIMITER + boundaryString + CRLF, encoding);
                this.writeText(requestOutputStream, String.format("Content-Disposition: form-data; name=\"%s\"", paramName) + CRLF + CRLF, encoding);
                this.writeText(requestOutputStream, paramValue.toString(), encoding);
                this.writeText(requestOutputStream, CRLF, encoding);
            }
        }
        this.writeText(requestOutputStream, DELIMITER + boundaryString + DELIMITER, encoding);
        this.writeText(requestOutputStream, CRLF, encoding);
    }

    protected byte[] getBytes(InputStream responseInputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[16384];
        int x = 0;
        while ((x = responseInputStream.read(bytes, 0, bytes.length)) != -1) {
            outputStream.write(bytes, 0, x);
        }
        outputStream.flush();
        return outputStream.toByteArray();
    }

    protected void infoWriteLine(String message) {
        if (this.verbose) {
            this.outputWriter.println(WebRequestHandler.newFormattedDate() + " " + message);
        }
    }

    protected void debugWriteLine(String message) {
        if (VeracodeCommand.isDebugEnabled()) {
            this.outputWriter.println(WebRequestHandler.newFormattedDate() + " " + message);
        }
    }

    protected void errorWriteLine(String message) {
        this.outputWriter.println(WebRequestHandler.newFormattedDate() + " " + message);
    }

    public void setVerboseMode(boolean verboseMode) {
        this.verbose = verboseMode;
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> pair : headers.entrySet()) {
                if (pair == null) continue;
                String key = pair.getKey();
                String value = pair.getValue();
                if (key == null || value == null) continue;
                this.addHeader(key, value);
            }
        }
    }

    public boolean isUnauthorized() throws IOException {
        this.infoWriteLine("Reading the response code");
        int responseCode = this.getResponseCode();
        this.infoWriteLine("Response code: " + responseCode);
        return responseCode == this.getUnauthorizedResponseCodeConstant();
    }

    private static String newFormattedDate() {
        return new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss.SSS]").format(new Date());
    }

    public void setOutputStream(PrintStream outputWriter) {
        this.outputWriter = outputWriter;
    }
}

