/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http.proxy;

import com.veracode.util.lang.StringUtility;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public final class ProxyData {
    private static final String DELIMITER_COLON = ":";
    private static final String DEFAULT_PROTOCOL = "https://";
    public static final String EMPTY_PROXY_MESSAGE = "The proxy is not specified.";
    public static final String INVALID_PROXY_MESSAGE = "The proxy is invalid.";
    private final Proxy proxy;
    private final String host;
    private final int port;
    private final String username;
    private final char[] password;

    public ProxyData(Proxy proxy, String username, char[] password) {
        this(proxy, null, 0, username, password);
    }

    public ProxyData(String host, int port, String username, char[] password) {
        this(null, host, port, username, password);
    }

    private ProxyData(Proxy proxy, String host, int port, String username, char[] password) {
        this.proxy = proxy;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public static final ProxyData create(String proxyURLStr) {
        return new ProxyData(proxyURLStr);
    }

    private ProxyData(String proxyURLStr) {
        this.proxy = null;
        if (proxyURLStr == null || (proxyURLStr = proxyURLStr.trim()).isEmpty()) {
            throw new IllegalArgumentException(EMPTY_PROXY_MESSAGE);
        }
        URL proxyURL = null;
        try {
            proxyURL = ProxyData.createURLFromProxyURLString(proxyURLStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(INVALID_PROXY_MESSAGE);
        }
        if (StringUtility.isNullOrEmpty(proxyURL.getHost())) {
            throw new IllegalArgumentException(INVALID_PROXY_MESSAGE);
        }
        this.host = proxyURL.getHost();
        this.port = proxyURL.getPort() > -1 ? proxyURL.getPort() : proxyURL.getDefaultPort();
        String userInfo = proxyURL.getUserInfo();
        String username = null;
        char[] password = null;
        if (!StringUtility.isNullOrEmpty(userInfo)) {
            if (userInfo.contains(DELIMITER_COLON)) {
                int colonIdx = userInfo.indexOf(DELIMITER_COLON);
                username = ProxyData.decodePartInURL(userInfo.substring(0, colonIdx));
                password = ProxyData.decodePartInURL(userInfo.substring(colonIdx + 1)).toCharArray();
            } else {
                username = ProxyData.decodePartInURL(userInfo);
                password = "".toCharArray();
            }
        }
        this.username = username;
        this.password = password;
    }

    private static URL createURLFromProxyURLString(String urlString) throws MalformedURLException {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            if (e.getMessage().contains("no protocol:") || e.getMessage().contains("unknown protocol:") && !urlString.contains("://")) {
                urlString = DEFAULT_PROTOCOL.concat(urlString);
                return ProxyData.createURLFromProxyURLString(urlString);
            }
            throw e;
        }
    }

    private static String decodePartInURL(String str) {
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(INVALID_PROXY_MESSAGE);
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }
}

