/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public final class HmacAuthHeaderGenerator {
    private static final String VERACODE_REQUEST_VERSION_STRING = "vcode_request_version_1";
    private static final String DATA_FORMAT = "id=%s&host=%s&url=%s&method=%s";
    private static final String HEADER_FORMAT = "%s id=%s,ts=%s,nonce=%s,sig=%s";
    private static final String VERACODE_HMAC_SHA_256 = "VERACODE-HMAC-SHA-256";
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String UTF_8 = "UTF-8";
    private static final String QUERY_SEPARATOR = "?";
    private static final SecureRandom secureRandom = new SecureRandom();

    private HmacAuthHeaderGenerator() {
    }

    public static String getVeracodeAuthorizationHeader(String id, String key, URL url, String httpMethod) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        String urlPath = url.getQuery() == null ? url.getPath() : url.getPath().concat(QUERY_SEPARATOR).concat(url.getQuery());
        String data = String.format(DATA_FORMAT, id, url.getHost(), urlPath, httpMethod);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String nonce = DatatypeConverter.printHexBinary(HmacAuthHeaderGenerator.generateRandomBytes(16)).toLowerCase(Locale.US);
        String signature = HmacAuthHeaderGenerator.getSignature(key, data, timestamp, nonce);
        return String.format(HEADER_FORMAT, VERACODE_HMAC_SHA_256, id, timestamp, nonce, signature);
    }

    private static String getSignature(String key, String data, String timestamp, String nonce) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        byte[] keyBytes = DatatypeConverter.parseHexBinary(key);
        byte[] nonceBytes = DatatypeConverter.parseHexBinary(nonce);
        byte[] encryptedNonce = HmacAuthHeaderGenerator.hmacSha256(nonceBytes, keyBytes);
        byte[] encryptedTimestamp = HmacAuthHeaderGenerator.hmacSha256(timestamp, encryptedNonce);
        byte[] signingKey = HmacAuthHeaderGenerator.hmacSha256(VERACODE_REQUEST_VERSION_STRING, encryptedTimestamp);
        byte[] signature = HmacAuthHeaderGenerator.hmacSha256(data, signingKey);
        return DatatypeConverter.printHexBinary(signature).toLowerCase(Locale.US);
    }

    private static byte[] hmacSha256(String data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        Mac mac = Mac.getInstance(HMAC_SHA_256);
        mac.init(new SecretKeySpec(key, HMAC_SHA_256));
        return mac.doFinal(data.getBytes(UTF_8));
    }

    private static byte[] hmacSha256(byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(HMAC_SHA_256);
        mac.init(new SecretKeySpec(key, HMAC_SHA_256));
        return mac.doFinal(data);
    }

    private static byte[] generateRandomBytes(int size) {
        byte[] key = new byte[size];
        secureRandom.nextBytes(key);
        return key;
    }
}

