/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.text;

import com.veracode.parser.annotations.Option;
import com.veracode.parser.core.AttributeMemberPair;
import com.veracode.parser.core.ParsingIssue;
import com.veracode.parser.enums.ParsingIssueType;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.util.ReflectionUtil;
import com.veracode.parser.util.StringUtility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TextBuilder {
    private static final int DefaultLineLength = 80;
    private static final int BuilderCapacity = 128;
    private final StringBuilder PreOptionsBuilder;
    private final StringBuilder OptionsBuilder;
    private final StringBuilder PostOptionsBuilder;
    private CommandLineOptionsBase _options;
    private int _lineLength;
    private String _heading;
    private int _optionsPaddingSpaces;
    public boolean AdditionalNewLineAfterOption;
    public boolean AddPeriodToHelpText;
    public boolean AppendErrorsBeforeOptions;
    public boolean AppendInfoBeforeOptions;
    public boolean ShowInfoInGroups;
    public String ErrorLabel;
    public String InfoLabel;
    public String UsageLabel;
    private int _errorLeadingSpaces;
    private int _infoLeadingSpaces;
    private int _optionLeadingSpaces;
    public boolean AddSwitchToError;
    public boolean AddSwitchToInfo;
    public boolean AddSwitchToOption;

    public CommandLineOptionsBase getOptions() {
        return this._options;
    }

    public void setOptions(CommandLineOptionsBase options) {
        this._options = options;
    }

    public int getLineLength() {
        return this._lineLength < 80 ? 80 : this._lineLength;
    }

    public void setLineLength(int lineLength) {
        this._lineLength = lineLength;
    }

    public String getHeading() {
        return this._heading;
    }

    public void setHeading(String heading) {
        this._heading = heading;
    }

    public int getOptionsPaddingSpaces() {
        return this._optionsPaddingSpaces > 0 ? this._optionsPaddingSpaces : 0;
    }

    public void setOptionsPaddingSpaces(int optionsPaddingSpaces) {
        this._optionsPaddingSpaces = optionsPaddingSpaces;
    }

    public int getErrorLeadingSpaces() {
        return this._errorLeadingSpaces > 0 ? this._errorLeadingSpaces : 0;
    }

    public void setErrorLeadingSpaces(int errorLeadingSpaces) {
        this._errorLeadingSpaces = errorLeadingSpaces;
    }

    public int getInfoLeadingSpaces() {
        return this._infoLeadingSpaces > 0 ? this._infoLeadingSpaces : 0;
    }

    public void setInfoLeadingSpaces(int infoLeadingSpaces) {
        this._infoLeadingSpaces = infoLeadingSpaces;
    }

    public int getOptionLeadingSpaces() {
        return this._optionLeadingSpaces > 0 ? this._optionLeadingSpaces : 0;
    }

    public void setOptionLeadingSpaces(int optionLeadingSpaces) {
        this._optionLeadingSpaces = optionLeadingSpaces;
    }

    public String getAllText() {
        this.appendErrorItems();
        this.appendInfoItems();
        this.appendOptionsItems();
        return this.compileText();
    }

    public String getAllTextSansOptions() {
        this.appendErrorItems();
        this.appendInfoItems();
        return this.compileText();
    }

    public String getOnlyErrorText() {
        String errorsText = this.generateErrorText();
        errorsText = !StringUtility.isNullOrEmpty(errorsText) ? this.ErrorLabel + "\r\n" + errorsText : "";
        return errorsText;
    }

    public static String getDeprecatedUserPassText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Authentication requires Veracode API ID and key credentials.");
        sb.append("\r\n");
        sb.append("Veracode no longer supports username and password authentication.");
        sb.append("\r\n");
        return sb.toString();
    }

    public String getWrapperVersionText() {
        return this.compileText();
    }

    private void appendErrorItems() {
        String errorsText = this.generateErrorText();
        if (!StringUtility.isNullOrEmpty(errorsText)) {
            boolean appendBeforeOptions = this.AppendErrorsBeforeOptions;
            this.appendLabel(this.ErrorLabel, appendBeforeOptions);
            this.appendNonOptionText(errorsText, appendBeforeOptions);
        }
    }

    private String generateErrorText() {
        StringBuilder errorsBuilder = new StringBuilder();
        for (ParsingIssue parsingError : this._options.parsingErrorList) {
            StringBuilder errorLine = new StringBuilder();
            this.appendNonOptionParam(errorLine, parsingError, this.getErrorLeadingSpaces(), this.AddSwitchToError);
            this.appendErrorText(errorLine, parsingError);
            errorsBuilder.append(errorLine.toString() + "\r\n");
        }
        return errorsBuilder.toString();
    }

    private void appendErrorText(StringBuilder errorLine, ParsingIssue parsingError) {
        if (parsingError.getParsingIssueType() != null) {
            switch (parsingError.getParsingIssueType()) {
                case Required: {
                    errorLine.append(" ");
                    errorLine.append("is required.");
                    break;
                }
                case RequiredBy: {
                    errorLine.append(" ");
                    errorLine.append("is required for the selected action.");
                    break;
                }
                case IncompatibleArgument: {
                    errorLine.append(" ");
                    errorLine.append("has an incompatible argument.");
                    break;
                }
                case MissingArgument: {
                    errorLine.append(" ");
                    errorLine.append("is missing an argument.");
                    break;
                }
                case InvalidArgument: {
                    errorLine.append(" ");
                    errorLine.append("has an invalid argument.");
                    break;
                }
                case InvalidPath: {
                    errorLine.append(" ");
                    errorLine.append("does not represent a valid path.");
                    break;
                }
                case MutualExclusiveness: {
                    errorLine.append(" ");
                    errorLine.append("is mutually exclusive.");
                    break;
                }
                case MutualInclusiveness: {
                    errorLine.append(" ");
                    errorLine.append("is required.");
                    break;
                }
                case Unknown: {
                    errorLine.append(" ");
                    errorLine.append("is not a valid parameter.");
                }
            }
        }
    }

    private void appendInfoItems() {
        String infoText;
        String string = infoText = this.ShowInfoInGroups ? this.generateInfoTextGroups() : this.generateInfoText();
        if (!StringUtility.isNullOrEmpty(infoText)) {
            boolean appendBeforeOptions = this.AppendInfoBeforeOptions;
            this.appendLabel(this.InfoLabel, appendBeforeOptions);
            this.appendNonOptionText(infoText, appendBeforeOptions);
        }
    }

    private String generateInfoTextGroups() {
        int maxParamLength = 0;
        for (ParsingIssue parsingInfo : this._options.parsingInfoList) {
            int currentLength;
            if (parsingInfo.getLongName() == null || parsingInfo.getParsingIssueType() != ParsingIssueType.OptionalBy || (currentLength = parsingInfo.getLongName().length()) <= maxParamLength) continue;
            maxParamLength = currentLength;
        }
        return this.makeGroups(this._options.parsingInfoList, maxParamLength);
    }

    private String makeGroups(List<ParsingIssue> list, int maxParamLength) {
        StringBuilder b1 = new StringBuilder();
        int maxLength = this.getInfoLeadingSpaces() + (this.AddSwitchToInfo ? this._options.longSwitch.length() : 0) + maxParamLength;
        int packSize = (this.getLineLength() - 1) / maxLength;
        for (int i = 0; i < packSize; ++i) {
            b1.append(String.format("%%%ds", i != packSize - 1 ? maxLength * -1 : -1));
        }
        String formatString = b1.toString();
        StringBuilder b2 = new StringBuilder();
        Object[] current = null;
        int x = 0;
        for (ParsingIssue issue : list) {
            if (issue.getParsingIssueType() != ParsingIssueType.OptionalBy) continue;
            if (x % packSize == 0) {
                current = new String[packSize];
                Arrays.fill(current, "");
            }
            String prefix = StringUtility.repeatChar(' ', this.getInfoLeadingSpaces()) + (this.AddSwitchToInfo ? this._options.longSwitch : "");
            current[x % packSize] = prefix + issue.getLongName();
            if (x % packSize == packSize - 1 || x == list.size() - 1) {
                b2.append(String.format(formatString, current) + "\r\n");
            }
            ++x;
        }
        return b2.toString();
    }

    private String generateInfoText() {
        StringBuilder infoBuilder = new StringBuilder();
        for (ParsingIssue parsingInfo : this._options.parsingInfoList) {
            StringBuilder infoLine = new StringBuilder();
            this.appendNonOptionParam(infoLine, parsingInfo, 0, this.AddSwitchToInfo);
            this.appendInfoText(infoLine, parsingInfo);
            infoBuilder.append(infoLine.toString() + "\r\n");
        }
        return infoBuilder.toString();
    }

    private void appendInfoText(StringBuilder infoLine, ParsingIssue parsingInfo) {
        if (parsingInfo.getParsingIssueType() != null) {
            switch (parsingInfo.getParsingIssueType()) {
                case OptionalBy: {
                    infoLine.append(" ");
                    infoLine.append("");
                }
            }
        }
    }

    private void appendLabel(String itemLabel, boolean appendBeforeOptions) {
        if (!StringUtility.isNullOrEmpty(itemLabel)) {
            if (appendBeforeOptions) {
                this.appendLineToStringBuilder(this.PreOptionsBuilder, itemLabel);
            } else {
                this.appendLineToStringBuilder(this.PostOptionsBuilder, itemLabel);
            }
        }
    }

    private void appendNonOptionParam(StringBuilder line, ParsingIssue parsingIssue, int leadingSpaces, boolean addSwitch) {
        line.append(StringUtility.repeatChar(' ', leadingSpaces));
        if (!StringUtility.isNullOrEmpty(parsingIssue.getShortName())) {
            if (addSwitch) {
                line.append(this._options.shortSwitch);
            }
            line.append(parsingIssue.getShortName());
            if (!StringUtility.isNullOrEmpty(parsingIssue.getLongName())) {
                line.append('/');
            }
        }
        if (!StringUtility.isNullOrEmpty(parsingIssue.getLongName())) {
            if (addSwitch) {
                line.append(this._options.longSwitch);
            }
            line.append(parsingIssue.getLongName());
        }
    }

    private void appendNonOptionText(String itemText, boolean appendBeforeOptions) {
        String[] lines;
        for (String line : lines = itemText.split("\r\n", -1)) {
            if (appendBeforeOptions) {
                this.appendLineToStringBuilder(this.PreOptionsBuilder, line);
                continue;
            }
            this.appendLineToStringBuilder(this.PostOptionsBuilder, line);
        }
    }

    private void appendOptionsItems() {
        this.appendOptionsText();
    }

    private void appendOptionsText() {
        ArrayList<AttributeMemberPair<Option, Field>> optionPairList = ReflectionUtil.retrieveMemberList(this._options);
        if (optionPairList.size() > 0) {
            boolean appendBeforeOptions = true;
            this.appendLabel(this.UsageLabel, appendBeforeOptions);
            int maxParamLength = this.getMaxParamLength(optionPairList);
            int helpTextLength = this.getLineLength() - (maxParamLength + this.getOptionLeadingSpaces() + this.getOptionsPaddingSpaces());
            for (AttributeMemberPair attributeMemberPair : optionPairList) {
                this.appendOptionText(attributeMemberPair, maxParamLength, helpTextLength);
            }
        }
    }

    private void appendOptionText(AttributeMemberPair<Option, Field> optionPair, int maxParamLength, int helpTextLength) {
        Option optionAttribute = optionPair.getLeft();
        Field optionMember = optionPair.getRight();
        String helpText = optionAttribute.helpText();
        StringBuilder paramBuilder = new StringBuilder(maxParamLength);
        if (optionAttribute.displayOnCLI()) {
            String[] names;
            this.OptionsBuilder.append(StringUtility.repeatChar(' ', this.getOptionLeadingSpaces()));
            if (!StringUtility.isNullOrEmpty(optionAttribute.shortName())) {
                if (this.AddSwitchToOption) {
                    paramBuilder.append(this._options.shortSwitch);
                }
                paramBuilder.append(String.format("%s", optionAttribute.shortName()));
                if (!StringUtility.isNullOrEmpty(optionAttribute.longName())) {
                    paramBuilder.append(", ");
                }
            }
            if (!StringUtility.isNullOrEmpty(optionAttribute.longName())) {
                if (this.AddSwitchToOption) {
                    paramBuilder.append(this._options.longSwitch);
                }
                paramBuilder.append(String.format("%s", optionAttribute.longName()));
            }
            if (paramBuilder.length() < maxParamLength) {
                this.OptionsBuilder.append(StringUtility.padRight(paramBuilder.toString(), maxParamLength));
            } else {
                this.OptionsBuilder.append(paramBuilder.toString());
            }
            this.OptionsBuilder.append(StringUtility.repeatChar(' ', this.getOptionsPaddingSpaces()));
            if (optionAttribute.required()) {
                helpText = StringUtility.isNullOrEmpty(helpText) ? String.format("%s", "<Required>") : String.format("%s %s", "<Required>", helpText);
            }
            if (optionAttribute.notSupported()) {
                helpText = StringUtility.isNullOrEmpty(helpText) ? String.format("%s", "<Not supported>") : String.format("%s %s", "<Not supported>", helpText);
            }
            if (optionAttribute.displayEnumOptions() && (names = ReflectionUtil.getEnumNames(optionMember, true)) != null) {
                String joinedNames = StringUtility.join(", ", names);
                helpText = StringUtility.isNullOrEmpty(helpText) ? String.format("%s %s", "Must be one of the following:", joinedNames) : String.format("%s %s %s", helpText, "Must be one of the following:", joinedNames);
            }
            if (!StringUtility.isNullOrEmpty(helpText)) {
                if (this.AddPeriodToHelpText && helpText.charAt(helpText.length() - 1) != '.') {
                    helpText = String.format("%s.", helpText);
                }
                do {
                    int wordBuffer = 0;
                    String[] words = helpText.split(String.valueOf(' '), -1);
                    for (int i = 0; i < words.length; ++i) {
                        if (words[i].length() < helpTextLength - wordBuffer) {
                            this.OptionsBuilder.append(words[i]);
                            if (helpTextLength - (wordBuffer += words[i].length()) <= 1 || i == words.length - 1) continue;
                            this.OptionsBuilder.append(" ");
                            ++wordBuffer;
                            continue;
                        }
                        if (words[i].length() < helpTextLength || wordBuffer != 0) break;
                        this.OptionsBuilder.append(words[i].substring(0, helpTextLength));
                        wordBuffer = helpTextLength;
                        break;
                    }
                    if ((helpText = helpText.substring(Math.min(wordBuffer, helpText.length())).trim()).length() <= 0) continue;
                    this.OptionsBuilder.append("\r\n");
                    this.OptionsBuilder.append(StringUtility.repeatChar(' ', maxParamLength + this.getOptionLeadingSpaces() + this.getOptionsPaddingSpaces()));
                } while (helpText.length() > helpTextLength);
            }
            this.OptionsBuilder.append(helpText);
            this.OptionsBuilder.append("\r\n");
        }
        if (this.AdditionalNewLineAfterOption) {
            this.OptionsBuilder.append("\r\n");
        }
    }

    private void appendLineToStringBuilder(StringBuilder builder, String line) {
        this.appendLineToStringBuilder(builder, line, this.getLineLength());
    }

    private void appendLineToStringBuilder(StringBuilder builder, String line, int lineLength) {
        if (builder.length() > 0) {
            builder.append("\r\n");
        }
        do {
            int wordBuffer = 0;
            String[] words = line.split(String.valueOf(' '), -1);
            for (int i = 0; i < words.length; ++i) {
                if (words[i].length() < lineLength - wordBuffer) {
                    builder.append(words[i]);
                    if (lineLength - (wordBuffer += words[i].length()) <= 1 || i == words.length - 1) continue;
                    builder.append(" ");
                    ++wordBuffer;
                    continue;
                }
                if (words[i].length() < lineLength || wordBuffer != 0) break;
                builder.append(words[i].substring(0, lineLength));
                wordBuffer = lineLength;
                break;
            }
            if ((line = line.substring(Math.min(wordBuffer, line.length()))).length() <= 0) continue;
            builder.append("\r\n");
        } while (line.length() > lineLength);
        builder.append(line);
    }

    private int getMaxParamLength(List<AttributeMemberPair<Option, Field>> optionList) {
        int length = 0;
        for (AttributeMemberPair<Option, Field> optionPair : optionList) {
            boolean hasLongName;
            Option option = optionPair.getLeft();
            int optionLength = 0;
            boolean hasShortName = !StringUtility.isNullOrEmpty(option.shortName());
            boolean bl = hasLongName = !StringUtility.isNullOrEmpty(option.longName());
            if (hasShortName) {
                optionLength += option.shortName().length();
                if (this.AddSwitchToOption) {
                    optionLength += this._options.shortSwitch.length();
                }
            }
            if (hasLongName) {
                optionLength += option.longName().length();
                if (this.AddSwitchToOption) {
                    optionLength += this._options.longSwitch.length();
                }
            }
            if (hasShortName && hasLongName) {
                optionLength += 2;
            }
            length = Math.max(length, optionLength);
        }
        return length;
    }

    private int getLength(String value) {
        if (value == null) {
            return 0;
        }
        return value.length();
    }

    private int getLength(StringBuilder value) {
        if (value == null) {
            return 0;
        }
        return value.length();
    }

    private String compileText() {
        int extraLength = 10;
        StringBuilder builder = new StringBuilder(this.getLength(this._heading) + this.getLength(this.PreOptionsBuilder) + this.getLength(this.OptionsBuilder) + this.getLength(this.PostOptionsBuilder) + 10);
        if (!StringUtility.isNullOrEmpty(this._heading)) {
            builder.append(this._heading);
            builder.append("\r\n");
        }
        if (this.PreOptionsBuilder != null && this.PreOptionsBuilder.length() > 0) {
            builder.append(this.PreOptionsBuilder.toString());
            builder.append("\r\n");
        }
        if (this.OptionsBuilder != null && this.OptionsBuilder.length() > 0) {
            builder.append(this.OptionsBuilder.toString());
        }
        if (this.PostOptionsBuilder != null && this.PostOptionsBuilder.length() > 0) {
            builder.append("\r\n");
            builder.append(this.PostOptionsBuilder.toString());
        }
        return builder.toString();
    }

    private TextBuilder(CommandLineOptionsBase options, int lineLength) {
        this._options = options;
        this._lineLength = lineLength;
        this.PreOptionsBuilder = new StringBuilder(128);
        this.OptionsBuilder = new StringBuilder(128);
        this.PostOptionsBuilder = new StringBuilder(128);
        this.AppendErrorsBeforeOptions = true;
        this.AppendInfoBeforeOptions = true;
        this.ErrorLabel = "Parsing error(s):";
        this.InfoLabel = "The following parameters are optional for the selected action:";
        this.UsageLabel = "Usage:";
        this._errorLeadingSpaces = 2;
        this._infoLeadingSpaces = 2;
        this._optionLeadingSpaces = 2;
        this.AddSwitchToError = true;
        this.AddSwitchToInfo = true;
        this.AddSwitchToOption = true;
        this.ShowInfoInGroups = true;
        this._optionsPaddingSpaces = 8;
        this.AdditionalNewLineAfterOption = false;
        this.AddPeriodToHelpText = true;
        this._heading = options.createHeading();
        Collections.sort(options.parsingErrorList, new ParsingIssue(null, null));
        Collections.sort(options.parsingInfoList, new ParsingIssue(null, null));
    }

    public static TextBuilder createInstance(CommandLineOptionsBase options) throws Exception {
        return TextBuilder.createInstance(options, 80);
    }

    public static TextBuilder createInstance(CommandLineOptionsBase options, int lineLength) throws Exception {
        return new TextBuilder(options, lineLength);
    }
}

