/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.util;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.parser.util.StringUtility;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    private static final VeracodeCommand.VeracodeParser vp = new VeracodeCommand.VeracodeParser();

    public static final Node getXmlNode(String xmlString, String xPath) throws Exception {
        Document xml = XmlUtils.getXmlDocument(xmlString);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        return (Node)xPathObj.evaluate(xPath, xml.getDocumentElement(), XPathConstants.NODE);
    }

    public static final NodeList getXmlNodeList(String xmlString, String xPath) throws Exception {
        Document xml = XmlUtils.getXmlDocument(xmlString);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        return (NodeList)xPathObj.evaluate(xPath, xml.getDocumentElement(), XPathConstants.NODESET);
    }

    public static final String getAttributeAsString(String xmlString, String xPath) throws Exception {
        Document xml = XmlUtils.getXmlDocument(xmlString);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        return (String)xPathObj.evaluate(xPath, xml.getDocumentElement(), XPathConstants.STRING);
    }

    public static final long getAttributeAsLong(String xmlString, String xPath) throws Exception {
        Document xml = XmlUtils.getXmlDocument(xmlString);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        Double attrValue = (Double)xPathObj.evaluate(xPath, xml.getDocumentElement(), XPathConstants.NUMBER);
        return attrValue.longValue();
    }

    public static long parseAccountId(String xmlBuildInfoResult) throws Exception {
        return XmlUtils.getAttributeAsLong(xmlBuildInfoResult, "/*[local-name()='buildinfo']/@account_id");
    }

    public static long parseAppId(String xmlBuildInfoResult) throws Exception {
        return XmlUtils.getAttributeAsLong(xmlBuildInfoResult, "/*[local-name()='buildinfo']/@app_id");
    }

    public static long parseBuildId(String xmlBuildInfoResult) throws Exception {
        return XmlUtils.getAttributeAsLong(xmlBuildInfoResult, "/*[local-name()='buildinfo']/@build_id");
    }

    public static final Document getXmlDocument(String xmlString) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes());
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(null);
            return db.parse(new InputSource(new InputStreamReader((InputStream)inputStream, "UTF-8")));
        }
        catch (SAXParseException e) {
            if (e.getMessage().contains("Character reference")) {
                String[] xmlStringAllLines = xmlString.split("\\R");
                String errorLineText = xmlStringAllLines[e.getLineNumber() - 1];
                if (xmlString.contains("applist")) {
                    String appId = "";
                    Pattern pattern = Pattern.compile("app_id=\"([^\"]+)\"");
                    Matcher matcher = pattern.matcher(errorLineText);
                    if (matcher.find()) {
                        appId = matcher.group(1);
                    }
                    vp.infoWriteLine("\r\n *Remove application with app_id=\"" + appId + "\" from the response due to the special characters.", new Object[0]);
                    return XmlUtils.getXmlDocument(xmlString.replace(errorLineText, " "));
                }
                vp.infoWriteLine("\r\n * Action cannot be performed due to special characters found in response.", new Object[0]);
                vp.infoWriteLine("\r\n * " + errorLineText.trim(), new Object[0]);
                return null;
            }
            throw e;
        }
    }

    public static final String getDecodedXmlResponse(String xmlString, boolean indentXml) {
        if (!StringUtility.isNullOrEmpty(xmlString)) {
            try {
                Document document = XmlUtils.getXmlDocument(xmlString);
                if (null == document) {
                    vp.infoWriteLine("\r\nUnable to decode response.", new Object[0]);
                    vp.setIsValidXml(false);
                    return "";
                }
                DOMSource domSource = new DOMSource(document);
                StringWriter sWriter = new StringWriter();
                StreamResult result = new StreamResult(sWriter);
                TransformerFactory tf = null;
                try {
                    tf = TransformerFactory.newInstance();
                    tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                }
                catch (Exception e) {
                    try {
                        tf = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
                        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    }
                    catch (Throwable t) {
                        tf = TransformerFactory.newInstance();
                        vp.infoWriteLine(String.format("\r\nUnable to load class. \"%s\".", !StringUtility.isNullOrEmpty(t.getMessage()) ? t.getMessage() : t.getClass().getCanonicalName()), new Object[0]);
                    }
                }
                Transformer transformer = tf.newTransformer();
                if (indentXml) {
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                }
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(domSource, result);
                xmlString = new String(sWriter.toString().getBytes(), StandardCharsets.UTF_8.name());
                xmlString = xmlString.replaceAll("(?m)^[\\s]*\r?\n", "");
            }
            catch (Exception e) {
                vp.infoWriteLine(String.format("\r\nUnable to decode response. \"%s\".", !StringUtility.isNullOrEmpty(e.getMessage()) ? e.getMessage() : e.getClass().getCanonicalName()), new Object[0]);
                vp.setIsValidXml(false);
                xmlString = "";
            }
        }
        return xmlString;
    }
}

