/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.application.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.application.model.api.ApplicationProfile;
import com.veracode.apiwrapper.application.model.api.ApplicationScan;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class Application {
    @SerializedName(value="app_profile_url")
    private String appProfileUrl = null;
    @SerializedName(value="created")
    private OffsetDateTime created = null;
    @SerializedName(value="guid")
    private String guid = null;
    @SerializedName(value="id")
    private Integer id = null;
    @SerializedName(value="last_completed_scan_date")
    private OffsetDateTime lastCompletedScanDate = null;
    @SerializedName(value="modified")
    private OffsetDateTime modified = null;
    @SerializedName(value="oid")
    private Integer oid = null;
    @SerializedName(value="organization_id")
    private Integer organizationId = null;
    @SerializedName(value="profile")
    private ApplicationProfile profile = null;
    @SerializedName(value="results_url")
    private String resultsUrl = null;
    @SerializedName(value="scans")
    private List<ApplicationScan> scans = null;
    @SerializedName(value="last_policy_compliance_check_date")
    private OffsetDateTime lastPolicyComplianceCheckDate = null;

    @ApiModelProperty(value="Unique path to the application profile.")
    public String getAppProfileUrl() {
        return this.appProfileUrl;
    }

    @ApiModelProperty(value="The date and time when the application was created. The date/time format is per RFC3339 and ISO-8601, and the timezone is UTC. Example: 2019-04-12T23:20:50.52Z.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public Application guid(String guid) {
        this.guid = guid;
        return this;
    }

    @ApiModelProperty(value="")
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Application id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ApiModelProperty(value="Date and time of the last completed scan for this application. The date/time format is per RFC3339 and ISO-8601, and the timezone is UTC. Example: 2019-04-12T23:20:50.52Z.")
    public OffsetDateTime getLastCompletedScanDate() {
        return this.lastCompletedScanDate;
    }

    @ApiModelProperty(value="The date and time when the application was modified. The date/time format is per RFC3339 and ISO-8601, and the timezone is UTC. Example: 2019-04-12T23:20:50.52Z.")
    public OffsetDateTime getModified() {
        return this.modified;
    }

    public Application oid(Integer oid) {
        this.oid = oid;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getOid() {
        return this.oid;
    }

    public void setOid(Integer oid) {
        this.oid = oid;
    }

    public Application organizationId(Integer organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public Application profile(ApplicationProfile profile) {
        this.profile = profile;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ApplicationProfile profile) {
        this.profile = profile;
    }

    @ApiModelProperty(value="Unique path to the latest results.")
    public String getResultsUrl() {
        return this.resultsUrl;
    }

    public Application scans(List<ApplicationScan> scans) {
        this.scans = scans;
        return this;
    }

    public Application addScansItem(ApplicationScan scansItem) {
        if (this.scans == null) {
            this.scans = new ArrayList<ApplicationScan>();
        }
        this.scans.add(scansItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ApplicationScan> getScans() {
        return this.scans;
    }

    public void setScans(List<ApplicationScan> scans) {
        this.scans = scans;
    }

    public Application lastPolicyComplianceCheckDate(OffsetDateTime lastPolicyComplianceCheckDate) {
        this.lastPolicyComplianceCheckDate = lastPolicyComplianceCheckDate;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getLastPolicyComplianceCheckDate() {
        return this.lastPolicyComplianceCheckDate;
    }

    public void setLastPolicyComplianceCheckDate(OffsetDateTime lastPolicyComplianceCheckDate) {
        this.lastPolicyComplianceCheckDate = lastPolicyComplianceCheckDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application application = (Application)o;
        return Objects.equals(this.appProfileUrl, application.appProfileUrl) && Objects.equals(this.created, application.created) && Objects.equals(this.guid, application.guid) && Objects.equals(this.id, application.id) && Objects.equals(this.lastCompletedScanDate, application.lastCompletedScanDate) && Objects.equals(this.modified, application.modified) && Objects.equals(this.oid, application.oid) && Objects.equals(this.organizationId, application.organizationId) && Objects.equals(this.profile, application.profile) && Objects.equals(this.resultsUrl, application.resultsUrl) && Objects.equals(this.scans, application.scans);
    }

    public int hashCode() {
        return Objects.hash(this.appProfileUrl, this.created, this.guid, this.id, this.lastCompletedScanDate, this.modified, this.oid, this.organizationId, this.profile, this.resultsUrl, this.scans);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Application {\n");
        sb.append("    appProfileUrl: ").append(this.toIndentedString(this.appProfileUrl)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastCompletedScanDate: ").append(this.toIndentedString(this.lastCompletedScanDate)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    oid: ").append(this.toIndentedString(this.oid)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    resultsUrl: ").append(this.toIndentedString(this.resultsUrl)).append("\n");
        sb.append("    scans: ").append(this.toIndentedString(this.scans)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

